/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AwaitExpression;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.PromisifyExpression;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class PromisifyHelper {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private TypeSystemHelper tsh;

    public CheckResult checkPromisifiablePreconditions(FunctionDefinition funDef) {
        boolean _greaterThan;
        Functions.Function1 _function;
        TypeRef lastFparTypeRef;
        Type _definedType = funDef.getDefinedType();
        EList _fpars = null;
        if ((TFunction)_definedType != null) {
            _fpars = ((TFunction)_definedType).getFpars();
        }
        TFormalParameter _last = null;
        if (_fpars != null) {
            _last = (TFormalParameter)IterableExtensions.last((Iterable)_fpars);
        }
        TFormalParameter lastFpar = _last;
        TypeRef _typeRef = null;
        if (lastFpar != null) {
            _typeRef = lastFpar.getTypeRef();
        }
        if (!((lastFparTypeRef = _typeRef) instanceof FunctionTypeExprOrRef)) {
            return CheckResult.MISSING_CALLBACK;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)funDef);
        FunctionTypeExprOrRef callbackTypeRef = (FunctionTypeExprOrRef)lastFparTypeRef;
        EList callbackFpars = callbackTypeRef.getFpars();
        List errorFpars = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)callbackFpars, (Functions.Function1)(_function = it -> this.isErrorOrSubtype(G, it.getTypeRef()))));
        int _size = errorFpars.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            return CheckResult.BAD_CALLBACK__MORE_THAN_ONE_ERROR;
        }
        TFormalParameter errorFpar = (TFormalParameter)IterableExtensions.head((Iterable)errorFpars);
        if (errorFpar != null && errorFpar != callbackFpars.get(0)) {
            return CheckResult.BAD_CALLBACK__ERROR_NOT_FIRST_ARG;
        }
        return CheckResult.OK;
    }

    public boolean isAutoPromisify(AwaitExpression awaitExpr) {
        return awaitExpr != null && !(awaitExpr.getExpression() instanceof PromisifyExpression) && this.isPromisifiableExpression(awaitExpr.getExpression());
    }

    public boolean isPromisifiableExpression(Expression expr) {
        RuleEnvironment G;
        TypeRef targetTypeRef;
        if (expr instanceof ParameterizedCallExpression && (targetTypeRef = this.ts.type(G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)expr), (TypableElement)((ParameterizedCallExpression)expr).getTarget())) instanceof FunctionTypeExprOrRef) {
            TFunction fun = ((FunctionTypeExprOrRef)targetTypeRef).getFunctionType();
            return fun != null && AnnotationDefinition.PROMISIFIABLE.hasAnnotation((TAnnotableElement)fun);
        }
        return false;
    }

    public TypeRef extractPromisifiedReturnType(Expression expr) {
        TypeRef _type;
        FunctionTypeExprOrRef targetTypeRef;
        RuleEnvironment G;
        TypeRef promisifiedReturnTypeRef;
        boolean _isPromisifiableExpression = this.isPromisifiableExpression(expr);
        if (_isPromisifiableExpression && (promisifiedReturnTypeRef = this.extractPromisifiedReturnType(G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)expr), targetTypeRef = (FunctionTypeExprOrRef)(_type = this.ts.type(G, (TypableElement)((ParameterizedCallExpression)expr).getTarget())))) != null) {
            return promisifiedReturnTypeRef;
        }
        return TypeRefsFactory.eINSTANCE.createUnknownTypeRef();
    }

    public TypeRef extractPromisifiedReturnType(RuleEnvironment G, FunctionTypeExprOrRef targetTypeRef) {
        TypeRef callbackTypeRef;
        TFormalParameter callbackFpar = (TFormalParameter)IterableExtensions.last((Iterable)targetTypeRef.getFpars());
        if (callbackFpar != null && (callbackTypeRef = callbackFpar.getTypeRef()) instanceof FunctionTypeExprOrRef) {
            TFormalParameter _head = (TFormalParameter)IterableExtensions.head((Iterable)((FunctionTypeExprOrRef)callbackTypeRef).getFpars());
            TypeRef _typeRef = null;
            if (_head != null) {
                _typeRef = _head.getTypeRef();
            }
            TypeRef callback1stFparTypeRef = _typeRef;
            boolean hasErrorFpar = this.isErrorOrSubtype(G, callback1stFparTypeRef);
            Object _xifexpression = null;
            _xifexpression = hasErrorFpar ? callback1stFparTypeRef : RuleEnvironmentExtensions.undefinedTypeRef(G);
            TypeRef errorTypeRef = _xifexpression;
            Object _xifexpression_1 = null;
            _xifexpression_1 = hasErrorFpar ? IterableExtensions.drop((Iterable)((FunctionTypeExprOrRef)callbackTypeRef).getFpars(), (int)1) : ((FunctionTypeExprOrRef)callbackTypeRef).getFpars();
            EList successFpars = _xifexpression_1;
            Functions.Function1 _function = it -> it.getTypeRef();
            Functions.Function1 _function_1 = it -> {
                Object _xifexpression_2 = null;
                _xifexpression_2 = it != null ? it : TypeRefsFactory.eINSTANCE.createUnknownTypeRef();
                return _xifexpression_2;
            };
            List successFparTypeRefs = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)successFpars, (Functions.Function1)_function), (Functions.Function1)_function_1));
            int len = successFparTypeRefs.size();
            ParameterizedTypeRef _xifexpression_2 = null;
            if (len == 0) {
                _xifexpression_2 = RuleEnvironmentExtensions.undefinedTypeRef(G);
            } else {
                TypeRef _xifexpression_3 = null;
                if (len == 1) {
                    _xifexpression_3 = (TypeRef)successFparTypeRefs.get(0);
                } else {
                    ParameterizedTypeRef _xifexpression_4 = null;
                    if (len <= 9) {
                        _xifexpression_4 = RuleEnvironmentExtensions.iterableNTypeRef(G, successFparTypeRefs.size(), (TypeArgument[])Conversions.unwrapArray((Object)successFparTypeRefs, TypeArgument.class));
                    } else {
                        ParameterizedTypeRef _xblockexpression = null;
                        TypeRef remaining = this.tsh.createUnionType(G, (TypeRef[])Conversions.unwrapArray((Object)IterableExtensions.drop((Iterable)successFparTypeRefs, (int)8), TypeRef.class));
                        Iterable _take = IterableExtensions.take((Iterable)successFparTypeRefs, (int)8);
                        Iterable _plus = Iterables.concat((Iterable)_take, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeRef[]{remaining})));
                        _xifexpression_4 = _xblockexpression = RuleEnvironmentExtensions.iterableNTypeRef(G, 9, (TypeArgument[])Conversions.unwrapArray((Object)_plus, TypeArgument.class));
                    }
                    _xifexpression_3 = _xifexpression_4;
                }
                _xifexpression_2 = _xifexpression_3;
            }
            ParameterizedTypeRef successTypeRef = _xifexpression_2;
            return TypeUtils.createPromiseTypeRef((BuiltInTypeScope)RuleEnvironmentExtensions.getBuiltInTypeScope(G), (TypeArgument)successTypeRef, (TypeArgument)errorTypeRef);
        }
        return null;
    }

    private boolean isErrorOrSubtype(RuleEnvironment G, TypeRef typeRef) {
        return typeRef != null && this.ts.subtypeSucceeded(G, (TypeArgument)typeRef, (TypeArgument)RuleEnvironmentExtensions.errorTypeRef(G));
    }

    public static enum CheckResult {
        OK,
        MISSING_CALLBACK,
        BAD_CALLBACK__MORE_THAN_ONE_ERROR,
        BAD_CALLBACK__ERROR_NOT_FIRST_ARG;

    }
}

