/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc;

import java.util.Stack;

public class JSDocCharScanner {
    public static final String JSDOC_START = "/**";
    public static final String MLDOC_START = "/*";
    public static final char TAG_START = '@';
    public static final char COMMENT_LINE_PREFIX = '*';
    private final String s;
    private int nextOffset;
    private int offset;
    private int nextFencePost;
    private final Stack<Integer> fencePosts = new Stack();

    public JSDocCharScanner(String s) {
        this(s, 0);
    }

    public JSDocCharScanner(String s, int initialOffset) {
        this(s, initialOffset, s.length());
    }

    public JSDocCharScanner(String s, int initialOffset, int maxOffsetExcluded) {
        this.s = s;
        this.nextFencePost = maxOffsetExcluded;
        this.nextOffset = initialOffset;
        this.offset = -1;
        this.skipJSDocStart();
        this.more();
    }

    protected JSDocCharScanner(JSDocCharScanner src, int maxOffsetExcluded) {
        this.s = src.s;
        this.nextFencePost = maxOffsetExcluded;
        this.nextOffset = src.nextOffset;
        this.offset = src.offset;
    }

    public ScannerState saveState() {
        return new ScannerState(this.nextOffset, this.offset);
    }

    public void restoreState(ScannerState state) {
        this.nextOffset = state.nextOffset_;
        this.offset = state.offset_;
    }

    public JSDocCharScanner copy() {
        return new JSDocCharScanner(this, this.nextFencePost);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void skipJSDocStart() {
        if (this.nextOffset == 0) {
            if (this.s.startsWith(JSDOC_START)) {
                this.nextOffset += 3;
            } else {
                if (!this.s.startsWith(MLDOC_START)) {
                    return;
                }
                this.nextOffset += 2;
            }
            while (this.hasNext() && JSDocCharScanner.isWhitespaceNoNL(this.peek())) {
                this.next();
            }
            if (JSDocCharScanner.isNL(this.peek())) {
                this.next();
            }
            this.skipLineStart();
        }
    }

    private boolean more() {
        if (this.nextOffset < 0) {
            return false;
        }
        int skippedWS = 0;
        char c = '\u0000';
        while (this.nextOffset + skippedWS < this.nextFencePost) {
            c = this.s.charAt(this.nextOffset + skippedWS);
            if (!Character.isWhitespace(c)) break;
            ++skippedWS;
        }
        if (this.nextOffset + 1 + skippedWS < this.nextFencePost && c == '*' && this.s.charAt(skippedWS + this.nextOffset + 1) == '/') {
            this.nextOffset = -1;
            return false;
        }
        if (this.nextOffset + skippedWS < this.nextFencePost) {
            return true;
        }
        this.nextOffset = -1;
        return false;
    }

    private char peekNextChar() {
        return this.s.charAt(this.nextOffset);
    }

    private void findNextCharacter() {
        if (this.more()) {
            char c;
            if (this.offset >= 0 && JSDocCharScanner.isNL(c = this.s.charAt(this.offset))) {
                this.skipLineStart();
            }
            this.more();
        }
    }

    /*
     * Unable to fully structure code
     */
    int findLineTagEnd() {
        oldNextOffset = this.nextOffset;
        try {
            this.nextOffset = this.offset;
            ** GOTO lbl20
            {
                ++this.nextOffset;
                do {
                    if (this.nextOffset < this.nextFencePost && !JSDocCharScanner.isNL(this.s.charAt(this.nextOffset))) continue block4;
                    nlpos = this.nextOffset;
                    while (this.nextOffset < this.nextFencePost && Character.isWhitespace(this.s.charAt(this.nextOffset))) {
                        ++this.nextOffset;
                    }
                    if (this.nextOffset < this.nextFencePost && this.s.charAt(this.nextOffset) == '*') {
                        ++this.nextOffset;
                    }
                    while (this.nextOffset < this.nextFencePost && JSDocCharScanner.isWhitespaceNoNL(this.s.charAt(this.nextOffset))) {
                        ++this.nextOffset;
                    }
                    if (this.nextOffset >= this.nextFencePost || this.s.charAt(this.nextOffset) != '@') continue;
                    var4_3 = nlpos;
                    return var4_3;
lbl20:
                    // 2 sources

                } while (this.nextOffset < this.nextFencePost);
            }
            var4_4 = this.nextOffset - 1;
            return var4_4;
        }
        finally {
            this.nextOffset = oldNextOffset;
        }
    }

    public static boolean isNL(char c) {
        return c == '\n' || c == '\r';
    }

    private static boolean isWhitespaceNoNL(char c) {
        if (JSDocCharScanner.isNL(c)) {
            return false;
        }
        return Character.isWhitespace(c);
    }

    private void skipLineStart() {
        char c;
        int savedNextOffset = this.nextOffset;
        while (this.more()) {
            c = this.peekNextChar();
            if (!JSDocCharScanner.isWhitespaceNoNL(c)) break;
            ++this.nextOffset;
        }
        if (!this.more()) {
            return;
        }
        c = this.peekNextChar();
        if (c != '*') {
            this.nextOffset = savedNextOffset;
        } else {
            ++this.nextOffset;
            if (this.more() && JSDocCharScanner.isWhitespaceNoNL(this.peekNextChar())) {
                ++this.nextOffset;
            }
        }
        savedNextOffset = this.nextOffset;
        while (this.more() && JSDocCharScanner.isWhitespaceNoNL(this.peekNextChar())) {
            ++this.nextOffset;
        }
        if (this.more() && this.peekNextChar() != '@') {
            this.nextOffset = savedNextOffset;
        }
    }

    public boolean hasNext() {
        return this.nextOffset >= 0 && this.nextOffset < this.nextFencePost;
    }

    public boolean skipped() {
        return this.offset + 1 != this.nextOffset;
    }

    public int offset() {
        return this.offset;
    }

    public int nextOffset() {
        return this.nextOffset;
    }

    public void skipWS() {
        while (this.hasNext() && Character.isWhitespace(this.peek())) {
            this.next();
        }
    }

    public char nextNonWS() {
        this.skipWS();
        return this.next();
    }

    public char next() {
        if (this.nextOffset >= 0 && this.nextOffset < this.nextFencePost) {
            char current = this.peek();
            this.offset = this.nextOffset++;
            this.findNextCharacter();
            return current;
        }
        return '\u0000';
    }

    public char peek() {
        if (this.nextOffset >= 0 && this.nextOffset < this.nextFencePost) {
            return this.s.charAt(this.nextOffset);
        }
        return '\u0000';
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.nextFencePost) {
            return '\u0000';
        }
        return this.s.charAt(index);
    }

    public void setNextOffset(int nextOffset) {
        this.nextOffset = nextOffset;
        this.offset = nextOffset - 1;
    }

    public void rewindToWS() {
        if (this.nextOffset == 0) {
            return;
        }
        --this.nextOffset;
        while (this.nextOffset > 0 && !Character.isWhitespace(this.s.charAt(this.nextOffset))) {
            --this.nextOffset;
        }
        this.offset = this.nextOffset - 1;
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        int from = Math.max(0, this.nextOffset - 10);
        int to = Math.min(this.nextOffset + 10, this.nextFencePost - 1);
        int i = from;
        while (i < to) {
            if (i == this.nextOffset) {
                strb.append("\u00ab");
            }
            strb.append(this.s.charAt(i));
            if (i == this.nextOffset) {
                strb.append("\u00bb");
            }
            ++i;
        }
        String pre = from != 0 ? "\u2026" : "";
        String post = to < this.nextFencePost - 1 ? "\u2026" : "";
        return String.valueOf(pre) + strb.toString() + post;
    }

    public int length() {
        return this.nextFencePost;
    }

    public void fence(int fencePosition) {
        if (this.offset > fencePosition) {
            throw new IndexOutOfBoundsException("Scanner offest " + this.offset + " already after fence position " + fencePosition);
        }
        this.fencePosts.push(this.nextFencePost);
        this.nextFencePost = fencePosition;
    }

    public void unfence() {
        this.nextFencePost = this.fencePosts.pop();
    }

    public final class ScannerState {
        int nextOffset_;
        int offset_;

        public ScannerState(int nextOffset, int offset) {
            this.nextOffset_ = nextOffset;
            this.offset_ = offset;
        }
    }
}

