/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.util;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

public class AnnotationUtil {
    public static <T> T newInstance(Class<T> type, Class<?> declarator, Annotation annotation) throws IllegalAccessException {
        Constructor<T> c;
        if (declarator != null) {
            try {
                c = type.getDeclaredConstructor(declarator.getClass(), annotation.annotationType());
                c.setAccessible(true);
                if (c != null) {
                    return c.newInstance(declarator, annotation);
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            c = type.getConstructor(annotation.annotationType());
            if (c != null) {
                return c.newInstance(annotation);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        try {
            c = type.getConstructor(new Class[0]);
            if (c != null) {
                return c.newInstance(new Object[0]);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static <T> List<T> newInstancesViaMetaAnnotation(Class<?> declarator, Class<? extends Annotation> metaAnnotationClass, Class<T> expected) {
        ArrayList result = Lists.newArrayList();
        Annotation[] annotationArray = declarator.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            Annotation metaAnnotation = annotation.annotationType().getAnnotation(metaAnnotationClass);
            T r = AnnotationUtil.newInstanceViaAnnotation(declarator, metaAnnotation, expected, annotation);
            if (r != null) {
                result.add(r);
            }
            ++n2;
        }
        return result;
    }

    public static <T> List<T> newInstancesViaMetaAnnotation(Method declarator, Class<? extends Annotation> metaAnnotationClass, Class<T> expected) {
        ArrayList result = Lists.newArrayList();
        Annotation[] annotationArray = declarator.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            Annotation metaAnnotation = annotation.annotationType().getAnnotation(metaAnnotationClass);
            T r = AnnotationUtil.newInstanceViaAnnotation(null, metaAnnotation, expected, annotation);
            if (r != null) {
                result.add(r);
            }
            ++n2;
        }
        return result;
    }

    public static <T> List<T> newInstancesViaMetaAnnotation(Method declarator, int paramIndex, Class<? extends Annotation> metaAnnotationClass, Class<T> expected) {
        ArrayList result = Lists.newArrayList();
        Annotation[][] annotations = declarator.getParameterAnnotations();
        if (paramIndex >= 0 && paramIndex < annotations.length) {
            Annotation[] annotationArray = annotations[paramIndex];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                Annotation metaAnnotation = annotation.annotationType().getAnnotation(metaAnnotationClass);
                T r = AnnotationUtil.newInstanceViaAnnotation(null, metaAnnotation, expected, annotation);
                if (r != null) {
                    result.add(r);
                }
                ++n2;
            }
        }
        return result;
    }

    public static <T> T newInstanceViaAnnotation(Class<?> declarator, Annotation annotation, Class<T> expected, Annotation parameter) {
        if (annotation != null) {
            Method[] methodArray = annotation.annotationType().getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method f = methodArray[n2];
                if (f.getReturnType() == Class.class) {
                    try {
                        T result;
                        Object objtype = f.invoke((Object)annotation, new Object[0]);
                        if (objtype instanceof Class && expected.isAssignableFrom((Class)objtype) && (result = AnnotationUtil.newInstance((Class)objtype, declarator, parameter)) != null) {
                            return result;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public static <T> T newInstanceViaAnnotation(Class<?> declarator, Class<? extends Annotation> AnnotationClass, Class<T> expected) {
        Annotation annotation = declarator.getAnnotation(AnnotationClass);
        return AnnotationUtil.newInstanceViaAnnotation(declarator, annotation, expected, annotation);
    }

    public static <T> T newInstanceViaMetaAnnotation(Class<?> declarator, Class<? extends Annotation> metaAnnotationClass, Class<T> expected) {
        Annotation[] annotationArray = declarator.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            Annotation metaAnnotation = annotation.annotationType().getAnnotation(metaAnnotationClass);
            T r = AnnotationUtil.newInstanceViaAnnotation(declarator, metaAnnotation, expected, annotation);
            if (r != null) {
                return r;
            }
            ++n2;
        }
        return null;
    }

    public static <T extends Annotation> T newInstanceWithDefaults(Class<T> annotationType) {
        Object proxy = Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.getDefaultValue();
            }
        });
        return (T)((Annotation)annotationType.cast(proxy));
    }
}

