/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator.internal;

import com.google.inject.Inject;
import java.io.File;
import org.eclipse.n4js.ui.navigator.internal.ResourceNode;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerBroker;
import org.eclipse.ui.internal.navigator.resources.workbench.ResourceExtensionSorter;

public class N4JSResourceExtensionSorter
extends ResourceExtensionSorter {
    @Inject
    private WorkingSetManagerBroker workingSetManagerBroker;

    protected int compareClass(Object e1, Object e2) {
        WorkingSetManager workingSetManager;
        if (e1 instanceof ResourceNode && e2 instanceof ResourceNode) {
            File f1 = ((ResourceNode)e1).getResource();
            File f2 = ((ResourceNode)e2).getResource();
            if (f1.isFile() == f2.isFile()) {
                return this.getComparator().compare(f1.getName(), f2.getName());
            }
            if (f1.isDirectory() && f2.isFile()) {
                return -1;
            }
            if (f1.isFile() && f2.isDirectory()) {
                return 1;
            }
        } else if (e1 instanceof WorkingSet && e2 instanceof WorkingSet && (workingSetManager = this.workingSetManagerBroker.getActiveManager()) != null) {
            WorkingSet ws1 = (WorkingSet)e1;
            WorkingSet ws2 = (WorkingSet)e2;
            return workingSetManager.compare(ws1, ws2);
        }
        return super.compareClass(e1, e2);
    }
}

