/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4idl.migrations;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.n4js.ts.types.TMigration;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class MigrationMatcher {
    private double bestDistance;
    private Set<TMigration> matches = new HashSet<TMigration>();

    public static MigrationMatcher emptyMatcher() {
        return new MigrationMatcher();
    }

    private MigrationMatcher() {
        this.bestDistance = Double.POSITIVE_INFINITY;
    }

    public void match(TMigration match, double distance) {
        if (!(this.bestDistance < distance)) {
            if (this.bestDistance == distance) {
                this.matches.add(match);
            } else {
                HashSet _hashSet = new HashSet(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TMigration[]{match})));
                this.matches = _hashSet;
                this.bestDistance = distance;
            }
        }
    }

    public boolean hasPerfectMatch() {
        double _distance = this.getDistance();
        return _distance == 0.0;
    }

    public double getDistance() {
        return this.bestDistance;
    }

    public List<TMigration> getAllMatches() {
        return IterableExtensions.toList(this.matches);
    }

    public TMigration anyMatch() {
        return (TMigration)IterableExtensions.head(this.matches);
    }

    public boolean isEmpty() {
        int _size = this.matches.size();
        return _size == 0;
    }
}

