/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.setup.workspace;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xpect.Environment;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.XpectRequiredEnvironment;
import org.eclipse.xpect.setup.XpectSetupComponent;
import org.eclipse.xpect.util.EnvironmentUtil;
import org.eclipse.xpect.xtext.lib.setup.FileSetupContext;
import org.eclipse.xpect.xtext.lib.setup.workspace.Container;
import org.eclipse.xpect.xtext.lib.setup.workspace.IResourceFactory;
import org.eclipse.xpect.xtext.lib.setup.workspace.Project;
import org.eclipse.xpect.xtext.lib.setup.workspace.ThisFile;
import org.eclipse.xpect.xtext.lib.setup.workspace.WorkspaceDefaultsSetup;

@XpectSetupComponent
@XpectRequiredEnvironment(value={Environment.PLUGIN_TEST})
@XpectImport(value={WorkspaceDefaultsSetup.class})
public class Workspace
extends Container<IWorkspaceRoot> {
    private boolean autobuild = false;

    public void buildIncrementally() {
        try {
            ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public void cleanWorkspace() {
        EnvironmentUtil.requireEnvironment((Environment[])new Environment[]{Environment.PLUGIN_TEST});
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = projects.length - 1;
        while (i >= 0) {
            try {
                projects[i].delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            --i;
        }
    }

    public Instance configureWorkspace(final FileSetupContext ctx) {
        EnvironmentUtil.requireEnvironment((Environment[])new Environment[]{Environment.PLUGIN_TEST});
        final Instance instance = new Instance();
        try {
            IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
            if (description.isAutoBuilding() != this.isAutobuild()) {
                description.setAutoBuilding(this.isAutobuild());
                ResourcesPlugin.getWorkspace().setDescription(description);
            }
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    try {
                        Workspace.this.configure(ctx, root);
                        Workspace.this.createMembers(ctx, root, instance);
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.xpect.xtext.lib", "Error initializing test workspace", (Throwable)e));
                    }
                }
            }.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return instance;
    }

    protected <T> T findRecursive(Container<?> container, Class<T> type) {
        for (IResourceFactory<?, ?> child : container.getMemberFactories()) {
            T result;
            if (type.isInstance(child)) {
                return (T)child;
            }
            if (!(child instanceof Container) || (result = this.findRecursive((Container)((Object)child), type)) == null) continue;
            return result;
        }
        return null;
    }

    public Project getDefaultProject() {
        for (IResourceFactory fact : this.getMemberFactories()) {
            if (!(fact instanceof Project)) continue;
            return (Project)fact;
        }
        return null;
    }

    public ThisFile getThisFile() {
        return this.findRecursive(this, ThisFile.class);
    }

    public boolean isAutobuild() {
        return this.autobuild;
    }

    public void setAutobuild(boolean autobuild) {
        this.autobuild = autobuild;
    }

    public void waitForAutoBuild() {
        boolean interrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                interrupted = false;
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
            }
        } while (interrupted);
    }

    public static class Instance {
        private IFile thisFile;
        private IProject thisProject;
        private IWorkspace workspace;

        public IFile getThisFile() {
            return this.thisFile;
        }

        public IProject getThisProject() {
            return this.thisProject;
        }

        public IWorkspace getWorkspace() {
            return this.workspace;
        }

        public void setThisFile(IFile thisFile) {
            this.thisFile = thisFile;
        }

        public void setThisProject(IProject thisProject) {
            this.thisProject = thisProject;
        }

        public void setWorkspace(IWorkspace workspace) {
            this.workspace = workspace;
        }
    }
}

