/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.compare;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.compare.ProjectCompareResult;
import org.eclipse.n4js.compare.ProjectComparison;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.xtext.util.Arrays;

public class ProjectComparisonEntry {
    public static final String LABEL_MISSING = "*MISSING*";
    private final ProjectComparison root;
    private final ProjectComparisonEntry parent;
    private final List<ProjectComparisonEntry> children = new ArrayList<ProjectComparisonEntry>();
    private final IN4JSProject projectAPI;
    private final IN4JSProject[] projectImpl;
    private final EObject elementAPI;
    private final EObject[] elementImpl;
    private final ProjectCompareResult[] cachedCompareResults;

    public ProjectComparisonEntry(ProjectComparison root, IN4JSProject projectAPI, IN4JSProject ... projectImpl) {
        this(root, null, -1, projectAPI, projectImpl, null, null);
    }

    public ProjectComparisonEntry(ProjectComparisonEntry parent, int index, EObject elementAPI, EObject ... elementImpl) {
        this(parent.root, parent, index, null, null, elementAPI, elementImpl);
    }

    protected ProjectComparisonEntry(ProjectComparison root, ProjectComparisonEntry parent, int index, IN4JSProject projectAPI, IN4JSProject[] projectImpl, EObject elementAPI, EObject[] elementImpl) {
        if (root == null) {
            throw new IllegalArgumentException();
        }
        if (parent != null && parent.root != root) {
            throw new IllegalArgumentException();
        }
        if (projectImpl == null == (elementImpl == null)) {
            throw new IllegalArgumentException();
        }
        this.root = root;
        this.parent = parent;
        this.projectAPI = projectAPI;
        this.projectImpl = projectImpl;
        this.elementAPI = elementAPI;
        this.elementImpl = elementImpl;
        ProjectCompareResult[] projectCompareResultArray = this.cachedCompareResults = elementImpl != null ? new ProjectCompareResult[elementImpl.length] : null;
        if (parent != null) {
            parent.addChild(index, this);
        } else {
            root.internalAddRootEntry(this);
        }
        this.root.onEntryAdded(this);
    }

    private void addChild(int index, ProjectComparisonEntry child) {
        if (child != null) {
            if (index < 0) {
                index = this.children.size();
            }
            this.children.add(index, child);
        }
    }

    public ProjectComparison getRoot() {
        return this.root;
    }

    public ProjectComparisonEntry getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    public ProjectComparisonEntry[] getChildren() {
        return this.children.toArray(new ProjectComparisonEntry[this.children.size()]);
    }

    public int getChildIndex(ProjectComparisonEntry child) {
        return this.children.indexOf(child);
    }

    public ProjectComparisonEntry getChildForElementImpl(EObject elementImpl) {
        if (elementImpl == null) {
            throw new IllegalArgumentException("elementImpl may not be null");
        }
        ProjectComparisonEntry[] projectComparisonEntryArray = this.getChildren();
        int n = projectComparisonEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectComparisonEntry currE = projectComparisonEntryArray[n2];
            if (Arrays.contains((Object[])currE.elementImpl, (Object)elementImpl)) {
                return currE;
            }
            ++n2;
        }
        return null;
    }

    public ProjectComparisonEntry getChildForElementAPI(EObject elementAPI) {
        if (elementAPI == null) {
            throw new IllegalArgumentException("elementAPI may not be null");
        }
        ProjectComparisonEntry[] projectComparisonEntryArray = this.getChildren();
        int n = projectComparisonEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectComparisonEntry currE = projectComparisonEntryArray[n2];
            if (currE.elementAPI != null && currE.elementAPI.equals(elementAPI)) {
                return currE;
            }
            ++n2;
        }
        return null;
    }

    public int getImplCount() {
        if (this.projectImpl != null) {
            return this.projectImpl.length;
        }
        if (this.elementImpl != null) {
            return this.elementImpl.length;
        }
        return 0;
    }

    public boolean isProjectEntry() {
        return this.projectImpl != null;
    }

    public boolean isElementEntry() {
        return this.elementImpl != null;
    }

    public IN4JSProject getProjectAPI() {
        return this.projectAPI;
    }

    public IN4JSProject[] getProjectImpl() {
        return this.projectImpl;
    }

    public IN4JSProject getProjectImpl(int implIdx) {
        if (this.projectImpl != null) {
            return implIdx >= 0 && implIdx < this.projectImpl.length ? this.projectImpl[implIdx] : null;
        }
        return null;
    }

    public EObject getElementAPI() {
        return this.elementAPI;
    }

    public EObject[] getElementImpl() {
        return this.elementImpl;
    }

    public EObject getElementImpl(int implIdx) {
        if (this.elementImpl != null) {
            return implIdx >= 0 && implIdx < this.elementImpl.length ? this.elementImpl[implIdx] : null;
        }
        return null;
    }

    public Object getProjectOrElementApi() {
        return this.projectAPI != null ? this.projectAPI : this.elementAPI;
    }

    public Object getProjectOrElementImpl(int implIdx) {
        if (this.isProjectEntry()) {
            return this.getProjectImpl(implIdx);
        }
        return this.getElementImpl(implIdx);
    }

    public EObject[] getAllElements() {
        if (this.isElementEntry()) {
            ArrayList<EObject> result = new ArrayList<EObject>();
            if (this.elementAPI != null) {
                result.add(this.elementAPI);
            }
            EObject[] eObjectArray = this.elementImpl;
            int n = this.elementImpl.length;
            int n2 = 0;
            while (n2 < n) {
                EObject currElemImpl = eObjectArray[n2];
                if (currElemImpl != null) {
                    result.add(currElemImpl);
                }
                ++n2;
            }
            return result.toArray(new EObject[result.size()]);
        }
        return new EObject[0];
    }

    public ProjectCompareResult getCachedCompareResult(int implIdx) {
        if (this.isElementEntry() && implIdx >= 0 && implIdx < this.cachedCompareResults.length) {
            return this.cachedCompareResults[implIdx];
        }
        return null;
    }

    public void storeCachedCompareResult(int implIdx, ProjectCompareResult result) {
        if (this.isElementEntry() && implIdx >= 0 && implIdx < this.cachedCompareResults.length) {
            this.cachedCompareResults[implIdx] = result;
        }
    }

    public void clearCachedCompareResults() {
        if (this.isElementEntry()) {
            int idx = 0;
            while (idx < this.cachedCompareResults.length) {
                this.cachedCompareResults[idx] = null;
                ++idx;
            }
        }
    }

    public String getTextTEMP(int idx) {
        if (idx == -1) {
            return this.getTextAPI();
        }
        return this.getTextImpl(idx);
    }

    public String getTextAPI() {
        Object api = this.getProjectOrElementApi();
        if (api == null) {
            return "-";
        }
        return ProjectComparisonEntry.toText(api);
    }

    public String getTextImpl(int implIdx) {
        if (implIdx < 0 || implIdx >= this.getImplCount()) {
            return null;
        }
        Object api = this.getProjectOrElementApi();
        Object impl = this.getProjectOrElementImpl(implIdx);
        if (impl == null) {
            if (api != null) {
                return LABEL_MISSING;
            }
            return "-";
        }
        return ProjectComparisonEntry.toText(impl);
    }

    private static String toText(Object element) {
        if (element instanceof IN4JSProject) {
            return ((IN4JSProject)element).getProjectName();
        }
        if (element instanceof TModule) {
            return ((TModule)element).getQualifiedName();
        }
        if (element instanceof TMember) {
            return ((TMember)element).getMemberAsString();
        }
        if (element instanceof TFormalParameter) {
            return ((TFormalParameter)element).getFormalParameterAsString();
        }
        if (element instanceof Type) {
            return ((Type)element).getTypeAsString();
        }
        if (element instanceof TypeRef) {
            return ((TypeRef)element).getTypeRefAsString();
        }
        if (element instanceof IdentifiableElement) {
            return ((IdentifiableElement)element).getName();
        }
        return element != null ? element.toString() : null;
    }

    public boolean isInheritedTEMP(int idx) {
        if (idx == -1) {
            return this.isInherited();
        }
        return this.isInherited(idx);
    }

    public boolean isInherited() {
        EObject implParent = this.parent != null ? this.parent.getElementAPI() : null;
        EObject impl = this.getElementAPI();
        if (implParent instanceof ContainerType && impl instanceof TMember) {
            return impl.eContainer() != implParent;
        }
        return false;
    }

    public boolean isInherited(int implIdx) {
        EObject implParent = this.parent != null ? this.parent.getElementImpl(implIdx) : null;
        EObject impl = this.getElementImpl(implIdx);
        if (implParent instanceof ContainerType && impl instanceof TMember) {
            return impl.eContainer() != implParent;
        }
        return false;
    }

    public boolean isOverrideTEMP(int idx) {
        if (idx == -1) {
            return this.isOverride();
        }
        return this.isOverride(idx);
    }

    public boolean isOverride() {
        EObject impl = this.getElementAPI();
        if (impl instanceof TMember) {
            return ((TMember)impl).isDeclaredOverride();
        }
        return false;
    }

    public boolean isOverride(int implIdx) {
        EObject impl = this.getElementImpl(implIdx);
        if (impl instanceof TMember) {
            return ((TMember)impl).isDeclaredOverride();
        }
        return false;
    }

    public Stream<ProjectComparisonEntry> allChildren() {
        return Stream.concat(Stream.of(this), this.children.stream().flatMap(child -> child.allChildren()));
    }
}

