/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.proposals.packagejson;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.n4js.json.JSON.JSONArray;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONStringLiteral;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.ui.contentassist.IJSONProposalProvider;
import org.eclipse.n4js.json.ui.contentassist.JSONProposalFactory;
import org.eclipse.n4js.packagejson.PackageJsonProperties;
import org.eclipse.n4js.resource.XpectAwareFileExtensionCalculator;
import org.eclipse.n4js.utils.languages.N4LanguageUtils;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class PackageJsonProposalProvider
implements IJSONProposalProvider {
    @Inject
    private XpectAwareFileExtensionCalculator fileExtensionCalculator;

    public boolean isResponsible(EObject eObject) {
        return this.fileExtensionCalculator.getFilenameWithoutXpectExtension(eObject.eResource().getURI()).equals("package.json");
    }

    public void complete_NameValuePair(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        JSONProposalFactory nvpFactory = (JSONProposalFactory)N4LanguageUtils.getServiceForContext((String)"json", JSONProposalFactory.class).get();
        List<String> namePath = this.getJsonPathNames(model);
        Set<String> alreadyUsedNames = this.getAlreadyUsedNames(model);
        List pathProps = PackageJsonProperties.valuesOfPath(namePath);
        for (PackageJsonProperties pathProp : pathProps) {
            String name = pathProp.name;
            if (alreadyUsedNames.contains(name) || !this.isMatchingPrefix(context, name)) continue;
            String value = "";
            String descr = pathProp.description;
            ICompletionProposal pairProposal = null;
            if (pathProp.valueType == JSONStringLiteral.class) {
                pairProposal = nvpFactory.createNameValueProposal(context, name, value, descr);
            }
            if (pathProp.valueType == JSONArray.class) {
                pairProposal = nvpFactory.createNameArrayProposal(context, name, value, descr);
            }
            if (pathProp.valueType == JSONObject.class) {
                pairProposal = nvpFactory.createNameObjectProposal(context, name, value, descr);
            }
            if (pairProposal == null) continue;
            acceptor.accept(pairProposal);
        }
    }

    private boolean isMatchingPrefix(ContentAssistContext context, String name) {
        String prefix = context.getPrefix();
        if (prefix.isEmpty()) {
            return true;
        }
        return name.toLowerCase().startsWith(prefix.toLowerCase());
    }

    private List<String> getJsonPathNames(EObject model) {
        LinkedList<String> namePath = new LinkedList<String>();
        EObject eobj = model;
        while (!(eobj instanceof JSONDocument)) {
            if (eobj instanceof NameValuePair) {
                NameValuePair nvp = (NameValuePair)eobj;
                namePath.add(0, nvp.getName());
            }
            eobj = eobj.eContainer();
        }
        return namePath;
    }

    private Set<String> getAlreadyUsedNames(EObject model) {
        HashSet<String> alreadyUsedNames = new HashSet<String>();
        if (model instanceof JSONObject) {
            JSONObject jsonObj = (JSONObject)model;
            for (NameValuePair nvp : jsonObj.getNameValuePairs()) {
                alreadyUsedNames.add(nvp.getName());
            }
        }
        return alreadyUsedNames;
    }

    public void complete_JSONArray(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    public void complete_STRING(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    public void complete_JSONObject(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }
}

