/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetImpl;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerImpl;
import org.eclipse.n4js.ui.workingsets.WorkspaceRepositoriesProvider;
import org.eclipse.swt.graphics.Image;

public class ProjectLocationAwareWorkingSetManager
extends WorkingSetManagerImpl {
    private final WorkspaceRepositoriesProvider repositoriesProvider;
    private static final Path WS_ROOT_PATH = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().toPath();
    private final Multimap<String, IProject> projectLocations;
    private static final String REMOTE_EDIT_PROJECT_NATURE_ID = "org.eclipse.rse.ui.remoteSystemsTempNature";
    private Collection<Path> repositoryPaths;

    @Inject
    public ProjectLocationAwareWorkingSetManager(WorkspaceRepositoriesProvider repositoriesProvider) {
        this.repositoriesProvider = repositoriesProvider;
        this.projectLocations = this.initProjectLocation();
        this.repositoriesProvider.addWorkspaceRepositoriesChangedListener(repos -> this.reload());
    }

    @Override
    public String getLabel() {
        return "Project Location";
    }

    @Override
    public Optional<Image> getImage() {
        return ImageDescriptorCache.ImageRef.URL_LOCATION.asImage();
    }

    @Override
    protected List<WorkingSet> initializeWorkingSets() {
        if (this.projectLocations.isEmpty()) {
            this.projectLocations.putAll(this.initProjectLocation());
        }
        return Lists.newArrayList((Iterable)FluentIterable.from((Iterable)this.projectLocations.keySet()).transform(id -> new ProjectLocationWorkingSet((String)id, this)));
    }

    @Override
    public void discardWorkingSetCaches() {
        super.discardWorkingSetCaches();
        this.projectLocations.clear();
    }

    private Multimap<String, IProject> initProjectLocation() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        HashMultimap locations = HashMultimap.create();
        this.repositoryPaths = this.repositoriesProvider.getWorkspaceRepositories().stream().map(r -> r.getDirectory().getParentFile().toPath()).collect(Collectors.toSet());
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!this.isRemoteEditNature(project)) {
                String pair = this.getWorkingSetId(project);
                locations.put((Object)pair, (Object)project);
            }
            ++n2;
        }
        return locations;
    }

    private boolean isRemoteEditNature(IProject project) {
        try {
            return project.hasNature(REMOTE_EDIT_PROJECT_NATURE_ID);
        }
        catch (CoreException e) {
            return false;
        }
    }

    private String getWorkingSetId(IProject project) {
        Path projectPath = project.getLocation().toFile().toPath();
        Path parentPath = projectPath.getParent();
        if (WS_ROOT_PATH.equals(parentPath)) {
            return "Other Projects";
        }
        if (parentPath.startsWith(WS_ROOT_PATH)) {
            return parentPath.toFile().getName();
        }
        if (!project.isOpen()) {
            return "Other Projects";
        }
        for (Path repositoryPath : this.repositoryPaths) {
            if (repositoryPath.equals(projectPath)) {
                return projectPath.toFile().getName();
            }
            if (!projectPath.startsWith(repositoryPath)) continue;
            return parentPath.toFile().getName();
        }
        return "Other Projects";
    }

    public static final class ProjectLocationWorkingSet
    extends WorkingSetImpl {
        @VisibleForTesting
        public ProjectLocationWorkingSet(String id, ProjectLocationAwareWorkingSetManager manager) {
            super(id, manager);
        }

        @Override
        public ProjectLocationAwareWorkingSetManager getWorkingSetManager() {
            return (ProjectLocationAwareWorkingSetManager)super.getWorkingSetManager();
        }

        @Override
        public IAdaptable[] getElements() {
            return (IAdaptable[])Iterables.toArray((Iterable)this.getWorkingSetManager().projectLocations.get((Object)this.getId()), IAdaptable.class);
        }
    }
}

