/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.ui;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.runner.ui.AbstractLaunchConfigurationMainTab;
import org.eclipse.n4js.tester.TestConfiguration;
import org.eclipse.n4js.tester.TesterFrontEnd;
import org.eclipse.n4js.tester.ui.TestConfigurationConverter;
import org.eclipse.n4js.tester.ui.TestDiscoveryUIUtils;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseProject;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractTesterLaunchShortcut
implements ILaunchShortcut {
    @Inject
    private TesterFrontEnd testerFrontEnd;
    @Inject
    private TestConfigurationConverter testConfigConverter;
    @Inject
    private IN4JSCore n4jsCore;

    protected abstract String getTesterId();

    protected abstract String getLaunchConfigTypeID();

    public void launch(IEditorPart editor, String mode) {
        URI location = TestDiscoveryUIUtils.getLocationForEditor(editor);
        if (location == null) {
            throw new IllegalArgumentException("no valid location for given editor (should have been filtered out by property tester!!)");
        }
        this.launchTest(location, mode);
    }

    public void launch(ISelection selection, String mode) {
        URI location = TestDiscoveryUIUtils.getLocationForSelection(selection);
        if (location == null) {
            throw new IllegalArgumentException("no valid location for given selection (should have been filtered out by property tester!!)");
        }
        this.launchTest(location, mode);
    }

    protected void launchTest(URI resourceToTest, String mode) {
        TestConfiguration testConfig = this.testerFrontEnd.createConfiguration(this.getTesterId(), null, resourceToTest);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(this.getLaunchConfigTypeID());
        this.copyProjectsLaunchConfigSettings(resourceToTest, testConfig, type);
        ILaunchConfiguration launchConfig = this.testConfigConverter.toLaunchConfiguration(type, testConfig, null);
        DebugUITools.launch((ILaunchConfiguration)launchConfig, (String)mode);
    }

    private void copyProjectsLaunchConfigSettings(URI resourceToTest, TestConfiguration testConfig, ILaunchConfigurationType type) {
        IN4JSProject n4jsProject;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        com.google.common.base.Optional project = this.n4jsCore.findProject(resourceToTest);
        if (project.isPresent() && (n4jsProject = (IN4JSProject)project.get()) instanceof IN4JSEclipseProject) {
            try {
                String projectLocation = ((IN4JSEclipseProject)n4jsProject).getLocation().toPlatformString(true);
                Optional<ILaunchConfiguration> projectLaunchConfig = Arrays.stream(launchManager.getLaunchConfigurations(type)).filter(config -> {
                    try {
                        String resToTest = AbstractLaunchConfigurationMainTab.getResourceRunAsText((ILaunchConfiguration)config);
                        return projectLocation.equals(resToTest);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        return false;
                    }
                }).findAny();
                if (projectLaunchConfig.isPresent()) {
                    ILaunchConfiguration pconfig = projectLaunchConfig.get();
                    testConfig.setEnvironmentVariables(pconfig.getAttribute("ENV_VARS", Collections.emptyMap()));
                    testConfig.setEngineOptions(pconfig.getAttribute("ENGINE_OPTIONS", ""));
                    testConfig.setCustomEnginePath(pconfig.getAttribute("CUSTOM_ENGINE_PATH", ""));
                    testConfig.setSystemLoader(pconfig.getAttribute("SYSTEM_LOADER", ""));
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

