/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator.resources;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IAggregateWorkingSet;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.navigator.framelist.Frame;
import org.eclipse.ui.internal.navigator.framelist.FrameList;
import org.eclipse.ui.internal.navigator.framelist.TreeFrame;
import org.eclipse.ui.internal.navigator.resources.ResourceToItemsMapper;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.ICommonViewerMapper;

public final class ProjectExplorer
extends CommonNavigator {
    public static final String VIEW_ID = "org.eclipse.ui.navigator.ProjectExplorer";
    public static final int WORKING_SETS = 0;
    public static final int PROJECTS = 1;
    private int rootMode;
    private String workingSetLabel;

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        this.getCommonViewer().setMapper((ICommonViewerMapper)new ResourceToItemsMapper(this.getCommonViewer()));
    }

    public void updateTitle() {
        super.updateTitle();
        Object input = this.getCommonViewer().getInput();
        if (input == null || input instanceof IAggregateWorkingSet) {
            this.setContentDescription("");
            return;
        }
        if (!(input instanceof IResource)) {
            String label = ((ILabelProvider)this.getCommonViewer().getLabelProvider()).getText(input);
            if (label != null) {
                this.setContentDescription(label);
                return;
            }
            IWorkbenchAdapter wbadapter = (IWorkbenchAdapter)Adapters.adapt((Object)input, IWorkbenchAdapter.class);
            if (wbadapter != null) {
                this.setContentDescription(wbadapter.getLabel(input));
                return;
            }
            this.setContentDescription(input.toString());
            return;
        }
        IResource res = (IResource)input;
        this.setContentDescription(res.getName());
    }

    public String getFrameToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? (element instanceof IAggregateWorkingSet ? WorkbenchNavigatorMessages.ProjectExplorerPart_workingSetModel : (element instanceof IWorkingSet ? ((IWorkingSet)element).getLabel() : super.getFrameToolTipText(element))) : ((path = ((IResource)element).getFullPath()).isRoot() ? WorkbenchNavigatorMessages.ProjectExplorerPart_workspace : path.makeRelative().toString());
        if (this.rootMode == 1) {
            if (this.workingSetLabel == null) {
                return result;
            }
            if (result.length() == 0) {
                return NLS.bind((String)WorkbenchNavigatorMessages.ProjectExplorer_toolTip, (Object[])new String[]{this.workingSetLabel});
            }
            return NLS.bind((String)WorkbenchNavigatorMessages.ProjectExplorer_toolTip2, (Object[])new String[]{result, this.workingSetLabel});
        }
        if (element != null && !(element instanceof IWorkingSet) && this.getCommonViewer() != null) {
            FrameList frameList = this.getCommonViewer().getFrameList();
            if (frameList == null) {
                return result;
            }
            int index = frameList.getCurrentIndex();
            IWorkingSet ws = null;
            while (index >= 0) {
                Object input;
                Frame frame = frameList.getFrame(index);
                if (frame instanceof TreeFrame && (input = ((TreeFrame)frame).getInput()) instanceof IWorkingSet && !(input instanceof IAggregateWorkingSet)) {
                    ws = (IWorkingSet)input;
                    break;
                }
                --index;
            }
            if (ws != null) {
                return NLS.bind((String)WorkbenchNavigatorMessages.ProjectExplorer_toolTip3, (Object[])new String[]{ws.getLabel(), result});
            }
            return result;
        }
        return result;
    }

    public void setRootMode(int mode) {
        this.rootMode = mode;
    }

    public int getRootMode() {
        return this.rootMode;
    }

    public void setWorkingSetLabel(String label) {
        this.workingSetLabel = label;
    }

    public String getWorkingSetLabel() {
        return this.workingSetLabel;
    }

    protected void handleDoubleClick(DoubleClickEvent anEvent) {
        IStructuredSelection selection;
        Object element;
        ICommandService commandService = (ICommandService)this.getViewSite().getService(ICommandService.class);
        Command openProjectCommand = commandService.getCommand("org.eclipse.ui.project.openProject");
        if (openProjectCommand != null && openProjectCommand.isHandled() && openProjectCommand.isEnabled() && (element = (selection = (IStructuredSelection)anEvent.getSelection()).getFirstElement()) instanceof IProject && !((IProject)element).isOpen()) {
            try {
                openProjectCommand.executeWithChecks(new ExecutionEvent());
            }
            catch (CommandException ex) {
                IStatus status = WorkbenchNavigatorPlugin.createErrorStatus("'Open Project' failed", ex);
                WorkbenchNavigatorPlugin.getDefault().getLog().log(status);
            }
            return;
        }
        super.handleDoubleClick(anEvent);
    }
}

