/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.text;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.util.Strings;

public class WhitespaceTokenizer
implements Function<String, List<String>> {
    public List<String> apply(String input) {
        ArrayList result = Lists.newArrayList();
        if (!Strings.isEmpty((String)input)) {
            int lastOffset = 0;
            boolean lastWs = Character.isWhitespace(input.charAt(0));
            int offset = 1;
            while (offset < input.length()) {
                char c = input.charAt(offset);
                boolean ws = Character.isWhitespace(c);
                if (ws != lastWs) {
                    String token = input.substring(lastOffset, offset);
                    result.add(token);
                    lastOffset = offset;
                    lastWs = ws;
                }
                ++offset;
            }
            String token = input.substring(lastOffset, input.length());
            result.add(token);
        }
        return result;
    }
}

