/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextEditorInfo;
import org.eclipse.xtext.ui.testing.AbstractEditorTest;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.junit.Assert;

public abstract class AbstractEditorDoubleClickTextSelectionTest
extends AbstractEditorTest {
    @Inject
    private XtextEditorInfo xtextEditorInfo;
    @Inject
    @Extension
    private FileExtensionProvider _fileExtensionProvider;

    public String c() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("|");
        return _builder.toString();
    }

    public void assertSelectedTextAfterDoubleClicking(CharSequence it, String expected) {
        try {
            this.assertSelectedText((AbstractTextEditor)this.doubleClick(this.openEditor(this.createFile(this.getContent(it))), this.getCursorPosition(it)), expected);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String getContent(CharSequence text) {
        return text.toString().replace(this.c(), "");
    }

    protected IFile createFile(String content) {
        try {
            return IResourcesSetupUtil.createFile(this.getProjectName(), this.getFileName(), this.getFileExtension(), content);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String getProjectName() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Test");
        return _builder.toString();
    }

    protected String getFileName() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Foo");
        return _builder.toString();
    }

    protected String getFileExtension() {
        return this._fileExtensionProvider.getPrimaryFileExtension();
    }

    protected int getCursorPosition(CharSequence text) {
        int _xblockexpression = 0;
        int cursorPosition = text.toString().indexOf(this.c());
        if (cursorPosition == -1) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The input text");
            _builder.newLine();
            _builder.append((Object)text);
            _builder.newLineIfNotEmpty();
            _builder.append("must contain the '");
            String _c = this.c();
            _builder.append(_c);
            _builder.append("' special symbol indicating the current cursor position!");
            _builder.newLineIfNotEmpty();
            Assert.fail((String)_builder.toString());
        }
        _xblockexpression = cursorPosition;
        return _xblockexpression;
    }

    protected XtextEditor doubleClick(XtextEditor xtextEditor, int cursorPosition) {
        XtextEditor _xblockexpression = null;
        ISourceViewer viewer = xtextEditor.getInternalSourceViewer();
        viewer.setSelectedRange(cursorPosition, 0);
        StyledText _textWidget = viewer.getTextWidget();
        Event _event = new Event();
        Procedures.Procedure1 _function = it -> {
            it.button = 1;
        };
        Event _doubleArrow = (Event)ObjectExtensions.operator_doubleArrow((Object)_event, (Procedures.Procedure1)_function);
        _textWidget.notifyListeners(3, _doubleArrow);
        _xblockexpression = xtextEditor;
        return _xblockexpression;
    }

    protected void assertSelectedText(AbstractTextEditor textEditor, CharSequence expectedSelectedText) {
        ISelection _selection = textEditor.getSelectionProvider().getSelection();
        String actualSelectedText = ((ITextSelection)_selection).getText();
        Assert.assertEquals((Object)expectedSelectedText, (Object)actualSelectedText);
    }

    @Override
    protected String getEditorId() {
        return this.xtextEditorInfo.getEditorId();
    }
}

