/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.model;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.eclipse.n4js.flowgraphs.model.Node;

public abstract class AbstractEdge {
    public final Node start;
    public final Node end;
    private final int cachedHash;

    public AbstractEdge(Node start, Node end) {
        Preconditions.checkState((start != null ? 1 : 0) != 0, (Object)"Start node must not be null");
        Preconditions.checkState((end != null ? 1 : 0) != 0, (Object)"End node must not be null");
        Preconditions.checkState((start != end ? 1 : 0) != 0, (Object)"Edge must not have same Start/End nodes");
        this.start = start;
        this.end = end;
        this.cachedHash = Objects.hash(start, end);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractEdge)) {
            return false;
        }
        AbstractEdge edge = (AbstractEdge)obj;
        boolean equals = true;
        equals &= this.start.id == edge.start.id;
        return equals &= this.end.id == edge.end.id;
    }

    public int hashCode() {
        return this.cachedHash;
    }
}

