/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.dataflow.guards;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.dataflow.guards.Guard;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardFactory;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.Symbol;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolFactory;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.xtext.EcoreUtil2;

public class GuardStructure {
    final Expression condition;
    final boolean negate;
    private final List<Guard> guardList;
    private final Multimap<Symbol, Guard> guards = HashMultimap.create();

    GuardStructure(Expression condition, boolean negate) {
        this.condition = condition;
        this.negate = negate;
        this.guardList = this.getGuardList();
    }

    public void initSymbols(SymbolFactory symbolFactory) {
        Iterator<Guard> guardsIter = this.guardList.iterator();
        while (guardsIter.hasNext()) {
            Guard guard = guardsIter.next();
            guard.initSymbol(symbolFactory);
            Symbol symbol = guard.getSymbol();
            if (symbol != null) {
                this.guards.put((Object)symbol, (Object)guard);
                continue;
            }
            guardsIter.remove();
        }
    }

    public Collection<Guard> getGuards(Symbol symbol) {
        return this.guards.get((Object)symbol);
    }

    public boolean hasGuards(Symbol symbol) {
        return this.guards.containsKey((Object)symbol);
    }

    public List<Guard> allGuards() {
        return this.guardList;
    }

    private List<Guard> getGuardList() {
        LinkedList<Guard> gList = new LinkedList<Guard>();
        List allExpressions = EcoreUtil2.getAllContentsOfType((EObject)this.condition, Expression.class);
        allExpressions.add(this.condition);
        EObject conditionContainer = this.condition.eContainer();
        for (Expression expr : allExpressions) {
            Guard guard = GuardFactory.create(conditionContainer, expr, this.negate);
            if (guard == null) continue;
            gList.add(guard);
        }
        return gList;
    }
}

