/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.xpect.text.Table;
import org.eclipse.xpect.util.IDifferencer;

public class DifferencerImpl
implements IDifferencer {
    private static String format(List<?> left, List<?> right, Collection<?> matches) {
        Table table = new Table();
        table.setMaxCellWidth(5);
        table.setRowSeparatorHeight(0);
        table.setSeparatorCrossingBackground("+");
        Table.Row topHeader = table.getRow(0);
        Table.Row topIndex = table.getRow(1);
        topIndex.getBottomSeparator().setBackground("-").setHeight(1);
        topIndex.getCell(2).setText("-1");
        int i = 0;
        while (i < right.size()) {
            topHeader.getCell(i + 3).setText(right.get(i));
            topIndex.getCell(i + 3).setText(i);
            ++i;
        }
        Table.Column leftHeader = table.getColumn(0);
        Table.Column leftIndex = table.getColumn(1);
        leftIndex.getRightSeparator().setBackground("|");
        leftIndex.getCell(2).setText("-1");
        int i2 = 0;
        while (i2 < left.size()) {
            leftHeader.getCell(i2 + 3).setText(left.get(i2));
            leftIndex.getCell(i2 + 3).setText(i2);
            ++i2;
        }
        for (Object o : matches) {
            Match match = (Match)o;
            String dir = String.valueOf(match.direction.direction.name().charAt(0));
            table.getCell(match.left + 3, match.right + 3).setText(String.valueOf(match.cost) + dir);
        }
        return table.toString();
    }

    @Override
    public <T> List<IDifferencer.Match> diff(List<T> left, List<T> right, IDifferencer.ISimilarityFunction<? super T> similarityFunction) {
        State<T> state = new State<T>(left, right);
        DirectionState forward = new DirectionState(state, Direction.FORWARD);
        DirectionState backward = new DirectionState(state, Direction.BACKWARD);
        int leftSize = left.size();
        int rightSize = right.size();
        Solution<T> solution = null;
        ((State)state).unvisited.add(new Match(forward, -1, -1));
        ((State)state).unvisited.add(new Match(backward, leftSize, rightSize));
        while (!((State)state).unvisited.isEmpty()) {
            Match current = (Match)((State)state).unvisited.pollFirst();
            LinkedList<Match> newMatches = new LinkedList<Match>();
            switch (current.direction.direction) {
                case FORWARD: {
                    int forwardLeft = current.left + 1;
                    int forwardRight = current.right + 1;
                    if (forwardLeft < leftSize) {
                        newMatches.add(new Match(current, IDifferencer.MatchKind.LEFT_ONLY, forwardLeft, current.right, 1.0f));
                    }
                    if (forwardRight < rightSize) {
                        newMatches.add(new Match(current, IDifferencer.MatchKind.RIGHT_ONLY, current.left, forwardRight, 1.0f));
                    }
                    if (forwardLeft >= leftSize || forwardRight >= rightSize) break;
                    float similarity = Math.abs(similarityFunction.similarity(left.get(forwardLeft), right.get(forwardRight)));
                    if (similarity == 0.0f) {
                        newMatches.add(new Match(current, IDifferencer.MatchKind.EQUAL, forwardLeft, forwardRight, similarity));
                        break;
                    }
                    if (!(similarity < 1.0f)) break;
                    newMatches.add(new Match(current, IDifferencer.MatchKind.SIMILAR, forwardLeft, forwardRight, similarity));
                    break;
                }
                case BACKWARD: {
                    int backwardLeft = current.left - 1;
                    int backwardRight = current.right - 1;
                    if (backwardLeft >= 0) {
                        newMatches.add(new Match(current, IDifferencer.MatchKind.LEFT_ONLY, backwardLeft, current.right, 1.0f));
                    }
                    if (backwardRight >= 0) {
                        newMatches.add(new Match(current, IDifferencer.MatchKind.RIGHT_ONLY, current.left, backwardRight, 1.0f));
                    }
                    if (backwardLeft < 0 || backwardRight < 0) break;
                    float similarity = Math.abs(similarityFunction.similarity(left.get(backwardLeft), right.get(backwardRight)));
                    if (similarity == 0.0f) {
                        newMatches.add(new Match(current, IDifferencer.MatchKind.EQUAL, backwardLeft, backwardRight, similarity));
                        break;
                    }
                    if (!(similarity < 1.0f)) break;
                    newMatches.add(new Match(current, IDifferencer.MatchKind.SIMILAR, backwardLeft, backwardRight, similarity));
                }
            }
            for (Match match : newMatches) {
                Long key = ((long)match.left << 32) + (long)match.right;
                Match old = (Match)((State)state).visited.get(key);
                if (old == null) {
                    if (solution != null && !(((Solution)solution).cost > match.cost + current.cost)) continue;
                    ((State)state).visited.put(key, match);
                    ((State)state).unvisited.add(match);
                    continue;
                }
                if (old.direction == match.direction) continue;
                Solution<T> newSolution = new Solution<T>(state, match, old);
                if (solution != null && !newSolution.isBetterThan(solution)) continue;
                solution = newSolution;
                if (((State)state).unvisited.isEmpty() || !(((Match)((State)state).unvisited.last()).cost > old.cost)) continue;
                ((State)state).unvisited = new TreeSet<Match>((SortedSet<Match>)((State)state).unvisited.headSet(old, true));
            }
        }
        List<IDifferencer.Match> result = solution.toList();
        return result;
    }

    private static enum Direction {
        BACKWARD,
        FORWARD;

    }

    private static class DirectionState {
        private final Direction direction;
        private final State<?> state;

        public DirectionState(State<?> state, Direction direction) {
            this.state = state;
            this.direction = direction;
        }
    }

    private static class Match
    implements IDifferencer.Match,
    Comparable<Match> {
        private final float cost;
        private final DirectionState direction;
        private final IDifferencer.MatchKind kind;
        private final int left;
        private final Match previous;
        private final int right;
        private final float similarity;

        public Match(DirectionState direction, int left, int right) {
            this.direction = direction;
            this.kind = IDifferencer.MatchKind.EQUAL;
            this.previous = null;
            this.cost = 0.0f;
            this.similarity = 0.0f;
            this.left = left;
            this.right = right;
        }

        public Match(Match previous, IDifferencer.MatchKind kind, int left, int right, float similarity) {
            this.direction = previous.direction;
            this.kind = kind;
            this.previous = previous;
            this.similarity = similarity;
            this.cost = previous.cost + similarity;
            this.left = left;
            this.right = right;
        }

        @Override
        public int compareTo(Match o) {
            if (this.cost < o.cost) {
                return -1;
            }
            if (this.cost > o.cost) {
                return 1;
            }
            switch (this.kind) {
                case LEFT_ONLY: {
                    switch (o.kind) {
                        case RIGHT_ONLY: {
                            return this.direction.direction == Direction.FORWARD ? -1 : 1;
                        }
                    }
                }
                case RIGHT_ONLY: {
                    switch (o.kind) {
                        case LEFT_ONLY: {
                            return this.direction.direction == Direction.FORWARD ? 1 : -1;
                        }
                    }
                }
            }
            if (this.left < o.left) {
                return -1;
            }
            if (this.left > o.left) {
                return 1;
            }
            if (this.right < o.right) {
                return -1;
            }
            if (this.right > o.right) {
                return 1;
            }
            return 0;
        }

        @Override
        public IDifferencer.MatchKind getKind() {
            return this.kind;
        }

        @Override
        public int getLeft() {
            if (this.kind == IDifferencer.MatchKind.RIGHT_ONLY) {
                return -1;
            }
            return this.left;
        }

        @Override
        public int getRight() {
            if (this.kind == IDifferencer.MatchKind.LEFT_ONLY) {
                return -1;
            }
            return this.right;
        }

        @Override
        public float getSimilarity() {
            switch (this.kind) {
                case EQUAL: {
                    return 0.0f;
                }
                case LEFT_ONLY: 
                case RIGHT_ONLY: {
                    return 1.0f;
                }
                case SIMILAR: {
                    return this.similarity;
                }
            }
            return 0.0f;
        }

        public String toString() {
            switch (this.kind) {
                case EQUAL: {
                    return "[" + this.left + "==" + this.right + "]";
                }
                case LEFT_ONLY: {
                    return "[" + this.left + "---]";
                }
                case RIGHT_ONLY: {
                    return "[---" + this.right + "]";
                }
                case SIMILAR: {
                    return "[" + this.left + "~~" + this.right + "]";
                }
            }
            return "(unknownKind)";
        }
    }

    private static class Solution<T> {
        private final Match backwardsEnd;
        private final float cost;
        private final Match forwardEnd;
        private final State<T> state;

        public Solution(State<T> state, Match match1, Match match2) {
            Preconditions.checkArgument((match1.direction.state == state ? 1 : 0) != 0);
            Preconditions.checkArgument((match2.direction.state == state ? 1 : 0) != 0);
            Preconditions.checkArgument((match1.direction != match2.direction ? 1 : 0) != 0);
            Preconditions.checkArgument((match1.left == match2.left ? 1 : 0) != 0);
            Preconditions.checkArgument((match1.right == match2.right ? 1 : 0) != 0);
            this.forwardEnd = match1.direction.direction == Direction.FORWARD ? match1 : match2;
            this.backwardsEnd = match1.direction.direction == Direction.FORWARD ? match2 : match1;
            this.cost = match1.cost + match2.cost;
            this.state = state;
        }

        private int getlastLeft(Match m) {
            return m.kind == IDifferencer.MatchKind.RIGHT_ONLY ? this.getlastLeft(m.previous) : m.left;
        }

        private int getlastRight(Match m) {
            return m.kind == IDifferencer.MatchKind.LEFT_ONLY ? this.getlastRight(m.previous) : m.right;
        }

        public boolean isBetterThan(Solution<T> o) {
            if (this.cost < o.cost) {
                return true;
            }
            if (this.cost > o.cost) {
                return false;
            }
            return false;
        }

        public List<IDifferencer.Match> toList() {
            ToStrList result = new ToStrList(((State)this.state).left, ((State)this.state).right);
            ArrayList<Match> temp = new ArrayList<Match>();
            Match m = this.forwardEnd;
            while (m.previous != null) {
                temp.add(m);
                m = m.previous;
            }
            int i = temp.size() - 1;
            while (i >= 0) {
                result.add((IDifferencer.Match)temp.get(i));
                --i;
            }
            int lastLeft = this.getlastLeft(this.forwardEnd);
            int lastRight = this.getlastRight(this.forwardEnd);
            Match m2 = this.backwardsEnd;
            while (m2.previous != null) {
                switch (m2.kind) {
                    case LEFT_ONLY: {
                        if (m2.left <= lastLeft) break;
                        result.add(m2);
                        break;
                    }
                    case RIGHT_ONLY: {
                        if (m2.right <= lastRight) break;
                        result.add(m2);
                        break;
                    }
                    default: {
                        if (m2.left > lastLeft && m2.right > lastRight) {
                            result.add(m2);
                            break;
                        }
                        if (m2.left > lastLeft) {
                            result.add(new Match(m2.previous, IDifferencer.MatchKind.LEFT_ONLY, m2.left, -1, m2.similarity));
                            break;
                        }
                        if (m2.right <= lastRight) break;
                        result.add(new Match(m2.previous, IDifferencer.MatchKind.RIGHT_ONLY, -1, m2.right, m2.similarity));
                    }
                }
                m2 = m2.previous;
            }
            return result;
        }

        public String toString() {
            return this.toList().toString();
        }
    }

    private static class State<T> {
        private final List<T> left;
        private final List<T> right;
        private TreeSet<Match> unvisited = new TreeSet();
        private final HashMap<Long, Match> visited = new HashMap();

        public State(List<T> left, List<T> right) {
            this.left = left;
            this.right = right;
        }

        public String toString() {
            return DifferencerImpl.format(this.left, this.right, this.unvisited);
        }
    }

    private static class ToStrList
    extends ArrayList<IDifferencer.Match> {
        private final List<?> left;
        private final List<?> right;

        private ToStrList(List<?> left, List<?> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public String toString() {
            return DifferencerImpl.format(this.left, this.right, this);
        }
    }
}

