/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.ExternalIndexSynchronizer;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.LibraryChange;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.external.NpmLogger;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.external.ExternalLibraryErrorMarkerManager;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.n4js.utils.URIUtils;

@Singleton
public class EclipseExternalIndexSynchronizer
extends ExternalIndexSynchronizer {
    @Inject
    private ExternalLibraryErrorMarkerManager externalErrorMarkerManager;
    @Inject
    private NpmLogger logger;

    public void synchronizeNpms(IProgressMonitor monitor) {
        this.synchronizeNpms(monitor, Collections.emptyList());
    }

    public void synchronizeNpms(IProgressMonitor monitor, Collection<LibraryChange> forcedChangeSet) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)11);
        try {
            try {
                Collection oldChangeSet = this.identifyChangeSet(forcedChangeSet, false);
                ExternalLibraryWorkspace.RegisterResult cleanResults = this.cleanChangesIndex((IProgressMonitor)subMonitor.split(1), oldChangeSet);
                Collection newChangesSet = this.identifyChangeSet(forcedChangeSet, true);
                this.buildChangesIndex((IProgressMonitor)subMonitor.split(9), newChangesSet, cleanResults);
            }
            catch (Exception e) {
                this.checkAndClearIndex((IProgressMonitor)subMonitor.split(1));
                subMonitor.done();
            }
        }
        finally {
            subMonitor.done();
        }
    }

    private ExternalLibraryWorkspace.RegisterResult cleanChangesIndex(IProgressMonitor monitor, Collection<LibraryChange> changeSet) {
        try {
            monitor.setTaskName("Cleaning new projects...");
            Set<URI> toBeRemovedProjects = this.getToBeRemovedProjects(changeSet);
            ExternalLibraryWorkspace.RegisterResult cleanResults = this.externalLibraryWorkspace.deregisterProjects(monitor, toBeRemovedProjects);
            this.printRegisterResults(cleanResults, "cleaned");
            ExternalLibraryWorkspace.RegisterResult registerResult = cleanResults;
            return registerResult;
        }
        finally {
            monitor.done();
        }
    }

    private void buildChangesIndex(IProgressMonitor monitor, Collection<LibraryChange> changeSet, ExternalLibraryWorkspace.RegisterResult cleanResults) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            Set<URI> toBeUpdated = this.getToBeBuildProjects(changeSet);
            for (URI cleanedPrjLoc : cleanResults.externalProjectsDone) {
                N4JSExternalProject project = this.externalLibraryWorkspace.getProject(cleanedPrjLoc);
                if (project == null) continue;
                toBeUpdated.add(cleanedPrjLoc);
            }
            subMonitor.setTaskName("Building new projects...");
            ExternalLibraryWorkspace.RegisterResult buildResult = this.externalLibraryWorkspace.registerProjects((IProgressMonitor)subMonitor.split(9), toBeUpdated);
            this.printRegisterResults(buildResult, "built");
            HashSet toBeScheduled = new HashSet();
            toBeScheduled.addAll(cleanResults.affectedWorkspaceProjects);
            toBeScheduled.addAll(buildResult.affectedWorkspaceProjects);
            this.externalLibraryWorkspace.scheduleWorkspaceProjects((IProgressMonitor)subMonitor.split(1), toBeScheduled);
        }
        finally {
            subMonitor.done();
        }
    }

    public void reindexAllExternalProjects(IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)11);
            monitor.setTaskName("Cleaning all projects...");
            this.externalLibraryWorkspace.deregisterAllProjects((IProgressMonitor)subMonitor.split(1));
            this.externalErrorMarkerManager.clearAllMarkers();
            this.synchronizeNpms((IProgressMonitor)subMonitor.split(10));
        }
        finally {
            monitor.done();
        }
    }

    private Set<URI> getToBeRemovedProjects(Collection<LibraryChange> changeSet) {
        HashSet<URI> toBeDeleted = new HashSet<URI>();
        for (LibraryChange change : changeSet) {
            switch (change.type) {
                case Added: {
                    N4JSExternalProject project = this.externalLibraryWorkspace.getProject(change.name);
                    if (project == null) break;
                    toBeDeleted.add(project.getIProject().getLocation());
                    break;
                }
                case Removed: 
                case Updated: {
                    N4JSExternalProject project = this.externalLibraryWorkspace.getProject(change.location);
                    if (project == null) break;
                    toBeDeleted.add(change.location);
                }
            }
        }
        return toBeDeleted;
    }

    private Set<URI> getToBeBuildProjects(Collection<LibraryChange> changeSet) {
        HashSet<URI> toBeUpdated = new HashSet<URI>();
        for (LibraryChange change : changeSet) {
            switch (change.type) {
                case Added: 
                case Updated: {
                    N4JSExternalProject project = this.externalLibraryWorkspace.getProject(change.location);
                    if (project != null) {
                        toBeUpdated.add(change.location);
                        break;
                    }
                    String msg = "ERROR: The project '" + change.name + "' was " + change.type;
                    msg = String.valueOf(msg) + " but could not be found at " + change.location + ".\n";
                    msg = String.valueOf(msg) + "       Hence, the project is not available in the workspace.";
                    this.logger.logInfo(msg);
                    break;
                }
                case Removed: {
                    N4JSExternalProject project = this.externalLibraryWorkspace.getProject(change.name);
                    if (project == null) break;
                    toBeUpdated.add(URIUtils.convert((IResource)project));
                }
            }
        }
        return toBeUpdated;
    }

    private void printRegisterResults(ExternalLibraryWorkspace.RegisterResult rr, String jobName) {
        SortedSet<String> prjNames;
        if (!rr.externalProjectsDone.isEmpty()) {
            prjNames = this.getProjectNamesFromLocations(rr.externalProjectsDone);
            this.logger.logInfo("External libraries " + jobName + ": " + String.join((CharSequence)", ", prjNames));
        }
        if (!rr.wipedProjects.isEmpty()) {
            prjNames = new TreeSet<String>();
            for (URI location : rr.wipedProjects) {
                String projectName = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI((URI)location);
                prjNames.add(projectName);
            }
            this.logger.logInfo("Projects deregistered: " + String.join((CharSequence)", ", prjNames));
        }
        if (!rr.affectedWorkspaceProjects.isEmpty()) {
            prjNames = this.getProjectNamesFromLocations(rr.affectedWorkspaceProjects);
            this.logger.logInfo("Workspace projects affected: " + String.join((CharSequence)", ", prjNames));
        }
    }

    private SortedSet<String> getProjectNamesFromLocations(Collection<URI> projectLocations) {
        TreeSet<String> prjNames = new TreeSet<String>();
        for (URI location : projectLocations) {
            IN4JSProject p = (IN4JSProject)this.core.findProject(location).orNull();
            prjNames.add(p.getProjectName());
        }
        return prjNames;
    }

    public void checkAndClearIndex(IProgressMonitor monitor) {
        Collection changeSet = this.identifyChangeSet(Collections.emptyList(), true);
        this.cleanRemovedProjectsFromIndex(monitor, changeSet);
    }

    private void cleanRemovedProjectsFromIndex(IProgressMonitor monitor, Collection<LibraryChange> changeSet) {
        monitor.setTaskName("Deregister removed projects...");
        HashSet<URI> cleanProjects = new HashSet<URI>();
        for (LibraryChange libChange : changeSet) {
            if (libChange.type != LibraryChange.LibraryChangeType.Removed) continue;
            cleanProjects.add(libChange.location);
        }
        ExternalLibraryWorkspace.RegisterResult cleanResult = this.externalLibraryWorkspace.deregisterProjects(monitor, cleanProjects);
        this.printRegisterResults(cleanResult, "deregistered");
    }
}

