/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.ExternalProjectsCollector;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.external.RebuildWorkspaceProjectsScheduler;
import org.eclipse.n4js.ui.external.ExternalLibraryBuilder;
import org.eclipse.n4js.ui.external.ExternalLocationsUpdatedListener;

public class ExternalIndexUpdater
implements ExternalLocationsUpdatedListener {
    private Collection<N4JSExternalProject> extProjectsDependingOnRemovedProjects;
    private Collection<IProject> wsProjectsDependingOnRemovedProjects;
    @Inject
    private ExternalLibraryWorkspace externalWorkspace;
    @Inject
    private ExternalProjectsCollector collector;
    @Inject
    private ExternalLibraryBuilder builder;
    @Inject
    private RebuildWorkspaceProjectsScheduler scheduler;

    @Override
    public void beforeLocationsUpdated(Set<URI> removedLocations, IProgressMonitor monitor) {
        ISchedulingRule rule = this.builder.getRule();
        try {
            Job.getJobManager().beginRule(rule, monitor);
            this.cleanRemovedLocations(removedLocations, monitor);
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    @Override
    public void afterLocationsUpdated(Set<URI> addedLocations, IProgressMonitor monitor) {
        ISchedulingRule rule = this.builder.getRule();
        try {
            Job.getJobManager().beginRule(rule, monitor);
            this.buildAddedLocations(addedLocations, monitor);
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    private void cleanRemovedLocations(Set<URI> removedLocations, IProgressMonitor monitor) {
        Collection removedProjects = this.externalWorkspace.getProjectsIn(removedLocations);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        this.builder.clean(removedProjects, (IProgressMonitor)subMonitor.newChild(1));
        subMonitor.worked(1);
        this.extProjectsDependingOnRemovedProjects = this.collector.getExtProjectsDependendingOn((Iterable)removedProjects);
        this.extProjectsDependingOnRemovedProjects.removeAll(removedProjects);
        subMonitor.worked(1);
        this.wsProjectsDependingOnRemovedProjects = this.collector.getWSProjectsDependendingOn((Iterable)removedProjects);
        this.wsProjectsDependingOnRemovedProjects.removeAll(removedProjects);
        subMonitor.worked(1);
    }

    private void buildAddedLocations(Set<URI> addedLocations, IProgressMonitor monitor) {
        Collection addedProjects = this.externalWorkspace.getProjectsIn(addedLocations);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        HashSet extProjectsToBuild = Sets.newHashSet();
        extProjectsToBuild.addAll(this.extProjectsDependingOnRemovedProjects);
        extProjectsToBuild.addAll(addedProjects);
        extProjectsToBuild.addAll(this.collector.getExtProjectsDependendingOn((Iterable)addedProjects));
        this.builder.build(extProjectsToBuild, (IProgressMonitor)subMonitor.newChild(1));
        subMonitor.worked(1);
        HashSet wsProjectsToRebuild = Sets.newHashSet();
        wsProjectsToRebuild.addAll(this.wsProjectsDependingOnRemovedProjects);
        wsProjectsToRebuild.addAll(this.collector.getWSProjectsDependendingOn((Iterable)addedProjects));
        wsProjectsToRebuild.addAll(this.collector.getWSProjectsDependendingOn((Iterable)extProjectsToBuild));
        this.scheduler.scheduleBuildIfNecessary((Iterable)wsProjectsToRebuild);
        subMonitor.worked(1);
    }
}

