/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.MemberAccess;
import org.eclipse.n4js.scoping.accessModifiers.MemberVisibilityChecker;
import org.eclipse.n4js.scoping.accessModifiers.StaticWriteAccessFilterScope;
import org.eclipse.n4js.scoping.accessModifiers.VisibilityAwareMemberScope;
import org.eclipse.n4js.scoping.members.IntersectionMemberScope;
import org.eclipse.n4js.scoping.members.MemberScope;
import org.eclipse.n4js.scoping.members.MemberScopeRequest;
import org.eclipse.n4js.scoping.members.TypingStrategyAwareMemberScope;
import org.eclipse.n4js.scoping.members.UnionMemberScope;
import org.eclipse.n4js.scoping.utils.CompositeScope;
import org.eclipse.n4js.scoping.utils.DynamicPseudoScope;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeRef;
import org.eclipse.n4js.ts.typeRefs.IntersectionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ts.types.AnyType;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TN4Classifier;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.TStructuralType;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.types.UndefinedType;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.n4js.xtext.scoping.FilterWithErrorMarkerScope;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class MemberScopingHelper {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private TypeSystemHelper tsh;
    @Inject
    private MemberScope.MemberScopeFactory memberScopeFactory;
    @Inject
    private MemberVisibilityChecker memberVisibilityChecker;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;

    public IScope createMemberScope(TypeRef receiverTypeRef, MemberAccess context, boolean checkVisibility, boolean staticAccess, boolean structFieldInitMode) {
        MemberScopeRequest _memberScopeRequest = new MemberScopeRequest(receiverTypeRef, (EObject)context, true, checkVisibility, staticAccess, structFieldInitMode);
        return this.decoratedMemberScopeFor(receiverTypeRef, _memberScopeRequest);
    }

    public IScope createMemberScopeAllowingNonContainedMembers(TypeRef receiverTypeRef, EObject context, boolean checkVisibility, boolean staticAccess, boolean structFieldInitMode) {
        MemberScopeRequest _memberScopeRequest = new MemberScopeRequest(receiverTypeRef, context, false, checkVisibility, staticAccess, structFieldInitMode);
        return this.decoratedMemberScopeFor(receiverTypeRef, _memberScopeRequest);
    }

    private IScope decoratedMemberScopeFor(TypeRef typeRef, MemberScopeRequest memberScopeRequest) {
        if (typeRef == null) {
            return IScope.NULLSCOPE;
        }
        IScope result = this.members(typeRef, memberScopeRequest);
        return result;
    }

    private IScope decorate(IScope scope, MemberScopeRequest memberScopeRequest, TypeRef receiverTypeRef) {
        boolean _equals = Objects.equal((Object)scope, (Object)IScope.NULLSCOPE);
        if (_equals) {
            return scope;
        }
        Object decoratedScope = scope;
        if (memberScopeRequest.checkVisibility && !FilterWithErrorMarkerScope.isDecoratedWithFilter((IScope)scope, VisibilityAwareMemberScope.class)) {
            VisibilityAwareMemberScope _visibilityAwareMemberScope = new VisibilityAwareMemberScope((IScope)decoratedScope, this.memberVisibilityChecker, receiverTypeRef, memberScopeRequest.context);
            decoratedScope = _visibilityAwareMemberScope;
        }
        if (memberScopeRequest.staticAccess && !FilterWithErrorMarkerScope.isDecoratedWithFilter((IScope)scope, StaticWriteAccessFilterScope.class)) {
            StaticWriteAccessFilterScope _staticWriteAccessFilterScope = new StaticWriteAccessFilterScope((IScope)decoratedScope, memberScopeRequest.context);
            decoratedScope = _staticWriteAccessFilterScope;
        }
        if (memberScopeRequest.checkVisibility && !FilterWithErrorMarkerScope.isDecoratedWithFilter((IScope)scope, TypingStrategyAwareMemberScope.class)) {
            TypingStrategyAwareMemberScope _typingStrategyAwareMemberScope = new TypingStrategyAwareMemberScope((IScope)decoratedScope, receiverTypeRef, memberScopeRequest.context);
            decoratedScope = _typingStrategyAwareMemberScope;
        }
        return decoratedScope;
    }

    public Iterable<IEObjectDescriptionWithError> getErrorsForMember(IScope scope, String memberName, boolean staticAccess) {
        Iterable descriptions = scope.getElements(QualifiedName.create((String)memberName));
        Functions.Function1 _function = d -> IEObjectDescriptionWithError.getDescriptionWithError((IEObjectDescription)d);
        Iterable errorsOrNulls = IterableExtensions.map((Iterable)descriptions, (Functions.Function1)_function);
        return IterableExtensions.filterNull((Iterable)errorsOrNulls);
    }

    private IScope _members(TypeRef type, MemberScopeRequest request) {
        return IScope.NULLSCOPE;
    }

    private IScope _members(UnknownTypeRef type, MemberScopeRequest request) {
        return new DynamicPseudoScope();
    }

    private IScope _members(ParameterizedTypeRef ptr, MemberScopeRequest request) {
        IScope result = this.membersOfType(ptr.getDeclaredType(), request);
        if (ptr.isDynamic() && !(result instanceof DynamicPseudoScope)) {
            IScope _decorate = this.decorate(result, request, (TypeRef)ptr);
            return new DynamicPseudoScope(_decorate);
        }
        return this.decorate(result, request, (TypeRef)ptr);
    }

    private IScope _members(ParameterizedTypeRefStructural ptrs, MemberScopeRequest request) {
        IScope result = this.membersOfType(ptrs.getDeclaredType(), request);
        if (ptrs.isDynamic() && !(result instanceof DynamicPseudoScope)) {
            IScope _decorate = this.decorate(result, request, (TypeRef)ptrs);
            return new DynamicPseudoScope(_decorate);
        }
        boolean _isEmpty = ptrs.getStructuralMembers().isEmpty();
        if (_isEmpty) {
            return this.decorate(result, request, (TypeRef)ptrs);
        }
        IScope _xifexpression = null;
        TStructuralType _structuralType = ptrs.getStructuralType();
        boolean _tripleNotEquals = _structuralType != null;
        _xifexpression = _tripleNotEquals ? this.memberScopeFactory.create(result, (ContainerType<?>)ptrs.getStructuralType(), request.context, request.staticAccess, request.structFieldInitMode) : this.memberScopeFactory.create(result, (List<? extends TMember>)ptrs.getStructuralMembers(), request.context, request.staticAccess, request.structFieldInitMode);
        IScope memberScopeRaw = _xifexpression;
        return this.decorate(memberScopeRaw, request, (TypeRef)ptrs);
    }

    private IScope _members(ThisTypeRef thisTypeRef, MemberScopeRequest request) {
        TypeRef ub = this.ts.upperBound(RuleEnvironmentExtensions.newRuleEnvironment(request.context), (TypeArgument)thisTypeRef);
        if (ub != null) {
            return this.members(ub, request);
        }
        return IScope.NULLSCOPE;
    }

    private IScope _members(TypeTypeRef ttr, MemberScopeRequest request) {
        MemberScopeRequest staticRequest = request.enforceStatic();
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment(request.context);
        Type ctrStaticType = this.tsh.getStaticType(G, ttr);
        Object staticMembers = this.membersOfType(ctrStaticType, staticRequest);
        if (ctrStaticType instanceof TEnum) {
            staticMembers = this.decorate(Scopes.scopeFor((Iterable)((TEnum)ctrStaticType).getLiterals(), (IScope)staticMembers), request, (TypeRef)ttr);
        }
        if (ttr.isDynamic() && !(staticMembers instanceof DynamicPseudoScope)) {
            IScope _decorate = this.decorate((IScope)staticMembers, staticRequest, (TypeRef)ttr);
            DynamicPseudoScope _dynamicPseudoScope = new DynamicPseudoScope(_decorate);
            staticMembers = _dynamicPseudoScope;
        }
        if (ctrStaticType instanceof TEnum && AnnotationDefinition.STRING_BASED.hasAnnotation((TAnnotableElement)ctrStaticType)) {
            return this.decorate((IScope)staticMembers, staticRequest, (TypeRef)ttr);
        }
        MemberScopeRequest instanceRequest = request.enforceInstance();
        BuiltInTypeScope builtInScope = BuiltInTypeScope.get((ResourceSet)this.getResourceSet((EObject)ttr, request.context));
        Object _xifexpression = null;
        boolean _isConstructorRef = ttr.isConstructorRef();
        _xifexpression = _isConstructorRef ? builtInScope.getFunctionType() : builtInScope.getObjectType();
        TObjectPrototype functionType = _xifexpression;
        IScope ftypeScope = this.membersOfType((Type)functionType, instanceRequest);
        IScope result = CompositeScope.create(this.decorate((IScope)staticMembers, staticRequest, (TypeRef)ttr), this.decorate(ftypeScope, instanceRequest, (TypeRef)ttr));
        return result;
    }

    private IScope _members(UnionTypeExpression uniontypeexp, MemberScopeRequest request) {
        boolean _activateDynamicPseudoScope = this.jsVariantHelper.activateDynamicPseudoScope(request.context);
        if (_activateDynamicPseudoScope) {
            return new DynamicPseudoScope();
        }
        Functions.Function1 _function = elementTypeRef -> {
            TypingStrategy _typingStrategy = elementTypeRef.getTypingStrategy();
            boolean structFieldInitMode = Objects.equal((Object)_typingStrategy, (Object)TypingStrategy.STRUCTURAL_FIELD_INITIALIZER);
            IScope scope = this.members((TypeRef)elementTypeRef, request.setStructFieldInitMode(structFieldInitMode));
            return scope;
        };
        List subScopes = ListExtensions.map((List)uniontypeexp.getTypeRefs(), (Functions.Function1)_function);
        int _size = subScopes.size();
        switch (_size) {
            case 0: {
                return IScope.NULLSCOPE;
            }
            case 1: {
                return (IScope)subScopes.get(0);
            }
        }
        return new UnionMemberScope((ComposedTypeRef)uniontypeexp, request, subScopes, this.ts);
    }

    private IScope _members(IntersectionTypeExpression intersectiontypeexp, MemberScopeRequest request) {
        boolean _isEmpty = intersectiontypeexp.getTypeRefs().isEmpty();
        if (_isEmpty) {
            return IScope.NULLSCOPE;
        }
        Functions.Function1 _function = elementTypeRef -> {
            TypingStrategy _typingStrategy = elementTypeRef.getTypingStrategy();
            boolean structFieldInitMode = Objects.equal((Object)_typingStrategy, (Object)TypingStrategy.STRUCTURAL_FIELD_INITIALIZER);
            IScope scope = this.members((TypeRef)elementTypeRef, request.setStructFieldInitMode(structFieldInitMode));
            return scope;
        };
        List subScopes = ListExtensions.map((List)intersectiontypeexp.getTypeRefs(), (Functions.Function1)_function);
        return new IntersectionMemberScope((ComposedTypeRef)intersectiontypeexp, request, subScopes, this.ts);
    }

    private IScope _members(FunctionTypeRef ftExpr, MemberScopeRequest request) {
        return this.membersOfFunctionTypeRef((FunctionTypeExprOrRef)ftExpr, request);
    }

    private IScope _members(FunctionTypeExpression ftExpr, MemberScopeRequest request) {
        return this.membersOfFunctionTypeRef((FunctionTypeExprOrRef)ftExpr, request);
    }

    private IScope membersOfFunctionTypeRef(FunctionTypeExprOrRef ftExpr, MemberScopeRequest request) {
        BuiltInTypeScope builtInTypeScope = BuiltInTypeScope.get((ResourceSet)this.getResourceSet((EObject)ftExpr, request.context));
        TObjectPrototype fType = builtInTypeScope.getFunctionType();
        IScope ret = this.membersOfType((Type)fType, request);
        return this.decorate(ret, request, (TypeRef)ftExpr);
    }

    private IScope _membersOfType(Type type, MemberScopeRequest request) {
        boolean _eIsProxy = type.eIsProxy();
        if (_eIsProxy) {
            return new DynamicPseudoScope();
        }
        boolean _activateDynamicPseudoScope = this.jsVariantHelper.activateDynamicPseudoScope(request.context);
        if (_activateDynamicPseudoScope) {
            return new DynamicPseudoScope();
        }
        return IScope.NULLSCOPE;
    }

    private IScope _membersOfType(UndefinedType type, MemberScopeRequest request) {
        boolean _activateDynamicPseudoScope = this.jsVariantHelper.activateDynamicPseudoScope(request.context);
        if (_activateDynamicPseudoScope) {
            return new DynamicPseudoScope();
        }
        return IScope.NULLSCOPE;
    }

    private IScope _membersOfType(Void type, MemberScopeRequest request) {
        return new DynamicPseudoScope();
    }

    private IScope _membersOfType(PrimitiveType prim, MemberScopeRequest request) {
        TClassifier boxedType = prim.getAutoboxedType();
        IScope _xifexpression = null;
        _xifexpression = boxedType != null ? this.membersOfType((Type)boxedType, request) : IScope.NULLSCOPE;
        return _xifexpression;
    }

    private IScope _membersOfType(ContainerType<?> type, MemberScopeRequest request) {
        Type rootSuperType;
        BuiltInTypeScope builtInTypeScope = BuiltInTypeScope.get((ResourceSet)this.getResourceSet((EObject)type, request.context));
        Object implicitSuperType = builtInTypeScope.getObjectType();
        if (type instanceof TN4Classifier) {
            boolean _tripleNotEquals;
            TypingStrategy _typingStrategy = ((TN4Classifier)type).getTypingStrategy();
            boolean bl = _tripleNotEquals = _typingStrategy != TypingStrategy.DEFAULT;
            if (_tripleNotEquals) {
                implicitSuperType = builtInTypeScope.getObjectType();
            } else if (type instanceof TClass) {
                if (((TClass)type).getSuperClassRef() == null || !Objects.equal((Object)((TClass)type).getSuperClassRef().getDeclaredType(), (Object)builtInTypeScope.getObjectType())) {
                    implicitSuperType = builtInTypeScope.getN4ObjectType();
                }
            } else {
                implicitSuperType = builtInTypeScope.getN4ObjectType();
            }
        } else if (type instanceof TObjectPrototype && (rootSuperType = this.getRootSuperType((TObjectPrototype)type)) instanceof PrimitiveType) {
            TClassifier boxedType = ((PrimitiveType)rootSuperType).getAutoboxedType();
            implicitSuperType = boxedType != null && !request.staticAccess ? boxedType : (ContainerType)rootSuperType;
        }
        IScope _xifexpression = null;
        boolean _activateDynamicPseudoScope = this.jsVariantHelper.activateDynamicPseudoScope(request.context);
        if (_activateDynamicPseudoScope) {
            DynamicPseudoScope _dynamicPseudoScope = new DynamicPseudoScope();
            _xifexpression = this.memberScopeFactory.create((IScope)_dynamicPseudoScope, (ContainerType<?>)implicitSuperType, request.context, request.staticAccess, request.structFieldInitMode);
        } else {
            _xifexpression = this.memberScopeFactory.create((ContainerType<?>)implicitSuperType, request.context, request.staticAccess, request.structFieldInitMode);
        }
        IScope implicitSuperTypeMemberScope = _xifexpression;
        return this.memberScopeFactory.create(implicitSuperTypeMemberScope, type, request.context, request.staticAccess, request.structFieldInitMode);
    }

    private IScope _membersOfType(TEnum enumeration, MemberScopeRequest request) {
        BuiltInTypeScope builtInTypeScope = BuiltInTypeScope.get((ResourceSet)this.getResourceSet((EObject)enumeration, request.context));
        TObjectPrototype _xifexpression = null;
        boolean _isStringBasedEnumeration = TypeSystemHelper.isStringBasedEnumeration(enumeration);
        _xifexpression = _isStringBasedEnumeration ? builtInTypeScope.getN4StringBasedEnumType() : builtInTypeScope.getN4EnumType();
        TObjectPrototype specificEnumType = _xifexpression;
        return this.membersOfType((Type)specificEnumType, request);
    }

    private IScope _membersOfType(TypeVariable typeVar, MemberScopeRequest request) {
        TypeRef declUB = typeVar.getDeclaredUpperBound();
        if (declUB != null) {
            return this.members(declUB, request);
        }
        BuiltInTypeScope builtInTypeScope = BuiltInTypeScope.get((ResourceSet)this.getResourceSet((EObject)typeVar, request.context));
        AnyType anyType = builtInTypeScope.getAnyType();
        return this.membersOfType((Type)anyType, request);
    }

    private IScope _membersOfType(TStructuralType structType, MemberScopeRequest request) {
        boolean _isEmpty = structType.getOwnedMembers().isEmpty();
        if (_isEmpty) {
            return IScope.NULLSCOPE;
        }
        return this.memberScopeFactory.create((ContainerType<?>)structType, request.context, request.staticAccess, request.structFieldInitMode);
    }

    private ResourceSet getResourceSet(EObject type, EObject context) {
        ResourceSet result = EcoreUtilN4.getResourceSet((EObject)type, (EObject[])new EObject[]{context});
        if (result == null) {
            throw new IllegalStateException("type or context must be contained in a ResourceSet");
        }
        return result;
    }

    private Type getRootSuperType(TObjectPrototype type) {
        TObjectPrototype curr = type;
        Type next = null;
        do {
            Type _xifexpression = null;
            if (curr instanceof TObjectPrototype) {
                ParameterizedTypeRef _superType = curr.getSuperType();
                Type _declaredType = null;
                if (_superType != null) {
                    _declaredType = _superType.getDeclaredType();
                }
                _xifexpression = _declaredType;
            }
            if ((next = _xifexpression) == null) continue;
            curr = next;
        } while (next != null);
        return curr;
    }

    private IScope members(TypeRef ftExpr, MemberScopeRequest request) {
        if (ftExpr instanceof FunctionTypeRef) {
            return this._members((FunctionTypeRef)ftExpr, request);
        }
        if (ftExpr instanceof ParameterizedTypeRefStructural) {
            return this._members((ParameterizedTypeRefStructural)ftExpr, request);
        }
        if (ftExpr instanceof FunctionTypeExpression) {
            return this._members((FunctionTypeExpression)ftExpr, request);
        }
        if (ftExpr instanceof IntersectionTypeExpression) {
            return this._members((IntersectionTypeExpression)ftExpr, request);
        }
        if (ftExpr instanceof ParameterizedTypeRef) {
            return this._members((ParameterizedTypeRef)ftExpr, request);
        }
        if (ftExpr instanceof ThisTypeRef) {
            return this._members((ThisTypeRef)ftExpr, request);
        }
        if (ftExpr instanceof TypeTypeRef) {
            return this._members((TypeTypeRef)ftExpr, request);
        }
        if (ftExpr instanceof UnionTypeExpression) {
            return this._members((UnionTypeExpression)ftExpr, request);
        }
        if (ftExpr instanceof UnknownTypeRef) {
            return this._members((UnknownTypeRef)ftExpr, request);
        }
        if (ftExpr != null) {
            return this._members(ftExpr, request);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(ftExpr, request).toString());
    }

    private IScope membersOfType(Type prim, MemberScopeRequest request) {
        if (prim instanceof PrimitiveType) {
            return this._membersOfType((PrimitiveType)prim, request);
        }
        if (prim instanceof TEnum) {
            return this._membersOfType((TEnum)prim, request);
        }
        if (prim instanceof TStructuralType) {
            return this._membersOfType((TStructuralType)prim, request);
        }
        if (prim instanceof UndefinedType) {
            return this._membersOfType((UndefinedType)prim, request);
        }
        if (prim instanceof ContainerType) {
            return this._membersOfType((ContainerType)prim, request);
        }
        if (prim instanceof TypeVariable) {
            return this._membersOfType((TypeVariable)prim, request);
        }
        if (prim != null) {
            return this._membersOfType(prim, request);
        }
        if (prim == null) {
            return this._membersOfType((Void)null, request);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(prim, request).toString());
    }
}

