/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.model;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;

public class BlockedTaskFinder {
    private Set<ICompositeCheatSheetTask> stateChangedTasks;
    private Set<ICompositeCheatSheetTask> impactedTasks;

    public Set<ICompositeCheatSheetTask> findBlockedTaskChanges(Set<ICompositeCheatSheetTask> stateChangedTasks) {
        this.stateChangedTasks = stateChangedTasks;
        this.impactedTasks = new HashSet<ICompositeCheatSheetTask>();
        this.visitChangedTasks();
        this.findSuccesors();
        return this.impactedTasks;
    }

    private void visitChangedTasks() {
        for (ICompositeCheatSheetTask nextTask : this.stateChangedTasks) {
            if (nextTask.getState() == 1) continue;
            this.findUnstartedChildren(nextTask);
        }
    }

    private void findUnstartedChildren(ICompositeCheatSheetTask task) {
        ICompositeCheatSheetTask[] children = task.getSubtasks();
        int i = 0;
        while (i < children.length) {
            ICompositeCheatSheetTask nextChild = children[i];
            if (!this.stateChangedTasks.contains(nextChild) && !this.impactedTasks.contains(nextChild)) {
                if (nextChild.getState() == 0) {
                    this.impactedTasks.add(nextChild);
                }
                this.findUnstartedChildren(nextChild);
            }
            ++i;
        }
    }

    private void findSuccesors() {
        for (AbstractTask abstractTask : this.stateChangedTasks) {
            ICompositeCheatSheetTask[] successors = abstractTask.getSuccessorTasks();
            int i = 0;
            while (i < successors.length) {
                ICompositeCheatSheetTask nextSuccessor = successors[i];
                if (nextSuccessor.getState() == 0) {
                    this.impactedTasks.add(nextSuccessor);
                }
                this.findUnstartedChildren(nextSuccessor);
                ++i;
            }
        }
    }
}

