/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Point;

abstract class LinkListener
implements MouseListener,
SelectionListener {
    private boolean active = false;

    LinkListener() {
    }

    public void register(StyledText styledText) {
        styledText.addSelectionListener((SelectionListener)this);
        styledText.addMouseListener((MouseListener)this);
    }

    public void unregister(StyledText styledText) {
        styledText.removeSelectionListener((SelectionListener)this);
        styledText.removeMouseListener((MouseListener)this);
    }

    public void widgetSelected(SelectionEvent e) {
        StyledText link = (StyledText)e.getSource();
        if (link.getSelectionCount() != 0) {
            this.active = false;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        StyledText link = (StyledText)e.getSource();
        this.active = e.button == 1 && link.getSelectionCount() == 0;
    }

    public void mouseUp(MouseEvent e) {
        Object data;
        StyleRange style;
        int offset;
        if (!this.active) {
            return;
        }
        this.active = false;
        if (e.button != 1) {
            return;
        }
        StyledText link = (StyledText)e.getSource();
        try {
            offset = link.getOffsetAtLocation(new Point(e.x, e.y));
        }
        catch (IllegalArgumentException ex) {
            offset = -1;
        }
        if (offset >= 0 && offset < link.getCharCount() && (style = link.getStyleRangeAtOffset(offset)) != null && (data = style.data) != null) {
            this.selected(data, (TypedEvent)e);
        }
    }

    protected abstract void selected(Object var1, TypedEvent var2);
}

