/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.HashSet;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceModelContentProvider;
import org.eclipse.team.internal.ui.mapping.ResourceModelTraversalCalculator;
import org.eclipse.team.internal.ui.synchronize.ImageManager;
import org.eclipse.team.ui.mapping.SynchronizationLabelProvider;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;

public class ResourceModelLabelProvider
extends SynchronizationLabelProvider
implements IFontProvider,
IResourceChangeListener,
ITreePathLabelProvider {
    public static final FastDiffFilter CONFLICT_FILTER = new FastDiffFilter(){

        public boolean select(IDiff diff) {
            if (diff instanceof IThreeWayDiff) {
                IThreeWayDiff twd = (IThreeWayDiff)diff;
                return twd.getDirection() == 768;
            }
            return false;
        }
    };
    private ILabelProvider provider;
    private ResourceModelContentProvider contentProvider;
    private ImageManager localImageManager;

    @Override
    public void init(ICommonContentExtensionSite site) {
        ITreeContentProvider aContentProvider = site.getExtension().getContentProvider();
        if (aContentProvider instanceof ResourceModelContentProvider) {
            this.contentProvider = (ResourceModelContentProvider)aContentProvider;
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        super.init(site);
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this.localImageManager != null) {
            this.localImageManager.dispose();
        }
        if (this.provider != null) {
            this.provider.dispose();
        }
        super.dispose();
    }

    @Override
    protected ILabelProvider getDelegateLabelProvider() {
        if (this.provider == null) {
            this.provider = new WorkbenchLabelProvider();
        }
        return this.provider;
    }

    @Override
    protected IDiff getDiff(Object elementOrPath) {
        IResource resource = this.getResource(elementOrPath);
        IResourceDiffTree tree = this.getDiffTree(elementOrPath);
        if (tree != null && resource != null) {
            IDiff delta = tree.getDiff(resource.getFullPath());
            return delta;
        }
        return null;
    }

    private IResource getResource(Object elementOrPath) {
        Object element = this.internalGetElement(elementOrPath);
        if (element instanceof IResource) {
            return (IResource)element;
        }
        return null;
    }

    @Override
    protected boolean isIncludeOverlays() {
        return true;
    }

    @Override
    protected boolean isBusy(Object elementOrPath) {
        IResource resource = this.getResource(elementOrPath);
        IResourceDiffTree tree = this.getDiffTree(elementOrPath);
        if (tree != null && resource != null) {
            return tree.getProperty(resource.getFullPath(), 1);
        }
        return super.isBusy(elementOrPath);
    }

    private TreePath internalGetPath(Object elementOrPath) {
        if (elementOrPath instanceof TreePath) {
            return (TreePath)elementOrPath;
        }
        return null;
    }

    @Override
    protected boolean hasDecendantConflicts(Object elementOrPath) {
        IResource resource = this.getResource(elementOrPath);
        IResourceDiffTree tree = this.getDiffTree(elementOrPath);
        if (tree != null && resource != null) {
            int depth = this.getTraversalCalculator().getLayoutDepth(resource, this.internalGetPath(elementOrPath));
            if (depth == 2 || resource.getType() == 1) {
                return tree.getProperty(resource.getFullPath(), 2);
            }
            return tree.hasMatchingDiffs(this.getTraversalCalculator().getTraversals(resource, this.internalGetPath(elementOrPath)), CONFLICT_FILTER);
        }
        return super.hasDecendantConflicts(elementOrPath);
    }

    protected IResourceDiffTree getDiffTree(Object elementOrPath) {
        ISynchronizationContext context = this.getContext();
        if (context != null) {
            return context.getDiffTree();
        }
        return null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        String[] markerTypes = new String[]{"org.eclipse.core.resources.problemmarker"};
        HashSet<IResource> handledResources = new HashSet<IResource>();
        int idx = 0;
        while (idx < markerTypes.length) {
            IMarkerDelta[] markerDeltas = event.findMarkerDeltas(markerTypes[idx], true);
            int i = 0;
            while (i < markerDeltas.length) {
                IMarkerDelta delta = markerDeltas[i];
                IResource resource = delta.getResource();
                while (resource != null && resource.getType() != 8 && !handledResources.contains(resource)) {
                    handledResources.add(resource);
                    resource = resource.getParent();
                }
                ++i;
            }
            ++idx;
        }
        if (!handledResources.isEmpty()) {
            Object[] resources = handledResources.toArray(new IResource[handledResources.size()]);
            this.updateLabels(resources);
        }
    }

    protected void updateLabels(Object[] resources) {
        Utils.asyncExec(() -> this.contentProvider.getStructuredViewer().update(resources, null), this.contentProvider.getStructuredViewer());
    }

    @Override
    protected String getDelegateText(Object elementOrPath) {
        String label;
        if (this.getConfiguration() != null && (label = this.getTraversalCalculator().getLabel(elementOrPath)) != null) {
            return label;
        }
        return super.getDelegateText(this.internalGetElement(elementOrPath));
    }

    @Override
    protected Image getDelegateImage(Object elementOrPath) {
        if (this.getConfiguration() != null && this.getTraversalCalculator().isCompressedFolder(elementOrPath)) {
            return this.getImageManager().getImage(TeamUIPlugin.getImageDescriptor("obj/compressed_folder_obj.png"));
        }
        return super.getDelegateImage(this.internalGetElement(elementOrPath));
    }

    private Object internalGetElement(Object elementOrPath) {
        if (elementOrPath instanceof TreePath) {
            TreePath tp = (TreePath)elementOrPath;
            return tp.getLastSegment();
        }
        return elementOrPath;
    }

    protected ResourceModelTraversalCalculator getTraversalCalculator() {
        return ResourceModelTraversalCalculator.getTraversalCalculator(this.getConfiguration());
    }

    private ISynchronizePageConfiguration getConfiguration() {
        return (ISynchronizePageConfiguration)this.getExtensionSite().getExtensionStateModel().getProperty("org.eclipse.team.ui.synchronizationPageConfiguration");
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        label.setImage(this.getImage(elementPath));
        label.setText(this.getText(elementPath));
        Font f = this.getFont(elementPath);
        if (f != null) {
            label.setFont(f);
        }
    }

    protected ImageManager getImageManager() {
        ISynchronizationContext context = this.getContext();
        if (context != null) {
            return ImageManager.getImageManager(context, this.getConfiguration());
        }
        if (this.localImageManager == null) {
            this.localImageManager = new ImageManager();
        }
        return this.localImageManager;
    }
}

