/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.antlr.replacements;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.n4js.antlr.replacements.PlaceholderReplacer;

public class Replacements {
    public static String getGrammarClass(String grammarContent) {
        Matcher m = Pattern.compile("public\\ class\\ ([a-zA-Z0-9_]+)\\ ").matcher(grammarContent);
        if (m.find()) {
            return m.group(1);
        }
        return "unknown grammar class";
    }

    public static String replaceAll(String in, String pattern, String replacement) {
        String result = in.replaceAll(pattern, replacement);
        if (result.equals(in)) {
            Thread.dumpStack();
            throw new IllegalStateException("Did not find '" + pattern + "' in grammar");
        }
        return result;
    }

    public static String replaceFirst(String in, String pattern, String replacement) {
        String result = in.replaceFirst(pattern, replacement);
        if (result.equals(in)) {
            Thread.dumpStack();
            throw new IllegalStateException("Did not find '" + pattern + "' in grammar");
        }
        return result;
    }

    public static String replace(String in, String lookup, String replacement) {
        String result = in.replace(lookup, replacement);
        if (result.equals(in)) {
            IllegalStateException ex = new IllegalStateException("Did not find '" + lookup + "' in grammar");
            ex.printStackTrace();
            throw ex;
        }
        return result;
    }

    public static String applyReplacement(String in, String replacementName) {
        try {
            PlaceholderReplacer replacer = new PlaceholderReplacer(replacementName);
            String result = replacer.replaceExactlyOnce(in);
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

