/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.dialog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.n4js.ui.dialog.CustomElementSelectionForm;
import org.eclipse.n4js.ui.wizard.workspace.SuffixText;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class CustomElementSelectionDialog
extends SelectionStatusDialog {
    public static final int CREATE_ID = 1025;
    private static final String DEFAULT_CREATE_BUTTON_LABEL = "Create";
    private final ArrayList<ViewerFilter> filters = new ArrayList();
    private final String elementLabel;
    private final String createButtonLabel;
    private IInputValidator inputValidator;
    private int autoExpandLevel = 0;
    protected TreeViewer treeViewer;
    protected Button createButton;
    protected SuffixText elementNameInput;

    protected CustomElementSelectionDialog(Shell parentShell, String elementLabel) {
        this(parentShell, elementLabel, DEFAULT_CREATE_BUTTON_LABEL);
    }

    protected CustomElementSelectionDialog(Shell parentShell, String elementLabel, String createButtonLabel) {
        super(parentShell);
        this.elementLabel = elementLabel;
        this.createButtonLabel = createButtonLabel;
    }

    protected Control createDialogArea(Composite parent) {
        CustomElementSelectionForm form = new CustomElementSelectionForm(parent, 4);
        form.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        TreeViewer v = form.getTreeViewer();
        for (ViewerFilter filter : this.filters) {
            v.addFilter(filter);
        }
        this.treeViewer = v;
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setComparator(new ViewerComparator());
        this.treeViewer.setAutoExpandLevel(this.getAutoExpandLevel());
        form.setElementLabel(this.elementLabel);
        this.elementNameInput = form.getElementInput();
        form.getElementInput().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("text") || evt.getPropertyName().equals("suffix")) {
                    CustomElementSelectionDialog.this.validateElementInput();
                    CustomElementSelectionDialog.this.elementInputChanged();
                }
            }
        });
        return form;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton = this.createButton(parent, 1025, this.createButtonLabel, false);
        super.createButtonsForButtonBar(parent);
    }

    public void addFilter(ViewerFilter filter) {
        this.filters.add(filter);
    }

    public void setInitialSelection(Object element) {
        this.setInitialSelections(new Object[]{element});
    }

    public void setInput(Object treeInput) {
        if (this.treeViewer != null) {
            this.treeViewer.setInput(treeInput);
            if (!this.getInitialElementSelections().isEmpty()) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection(this.getInitialElementSelections().get(0)));
            }
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.createPressed();
            return;
        }
        super.buttonPressed(buttonId);
    }

    protected void updateError(String errorMessage) {
        if (errorMessage != null) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.n4js.N4JS", errorMessage));
        } else {
            this.updateStatus((IStatus)new Status(0, "org.eclipse.n4js.N4JS", ""));
        }
    }

    protected void createPressed() {
    }

    protected void elementInputChanged() {
    }

    public int getAutoExpandLevel() {
        return this.autoExpandLevel;
    }

    public void setAutoExpandLevel(int autoExpandLevel) {
        this.autoExpandLevel = autoExpandLevel;
    }

    public void setInputValidator(IInputValidator inputValidator) {
        this.inputValidator = inputValidator;
    }

    protected void validateElementInput() {
        if (this.inputValidator != null) {
            String validationError = this.inputValidator.isValid(String.valueOf(this.elementNameInput.getText()) + this.elementNameInput.getSuffix());
            this.updateError(validationError);
        }
    }

    protected abstract void computeResult();
}

