/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.editoroverlay;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.resource.DefaultLocationInFileProvider;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.ITextRegion;

public class EditorOverlay
implements PaintListener {
    static final Color colorGreen = Display.getDefault().getSystemColor(5);
    static final Color colorBlue = Display.getDefault().getSystemColor(9);
    private final ILocationInFileProvider locFileProvider;
    private StyledText styledText;
    private final List<EObject> selectedElements = new LinkedList<EObject>();
    private EObject hoveredElement;

    public EditorOverlay() {
        this.locFileProvider = new DefaultLocationInFileProvider();
    }

    public void setHoveredElement(EObject currentSelection) {
        this.hoveredElement = currentSelection;
        this.draw();
    }

    public void setSelectedElement(List<EObject> selectedEO) {
        this.selectedElements.clear();
        this.selectedElements.addAll(selectedEO);
        this.draw();
    }

    private void draw() {
        XtextEditor editor = EditorUtils.getActiveXtextEditor();
        if (!(editor == null || this.hoveredElement == null && this.selectedElements.isEmpty())) {
            ISourceViewer isv = editor.getInternalSourceViewer();
            this.styledText = isv.getTextWidget();
            this.drawSelection();
        } else {
            this.clear();
        }
    }

    private void clear() {
        if (this.styledText != null && !this.styledText.isDisposed()) {
            this.styledText.removePaintListener((PaintListener)this);
            this.styledText.redraw();
        }
    }

    private void drawSelection() {
        if (this.styledText != null && !this.styledText.isDisposed()) {
            this.styledText.addPaintListener((PaintListener)this);
            this.styledText.redraw();
        }
    }

    private int[] getConturePointArray(EObject currentSelection) {
        Point sPoint;
        ITextRegion tr = this.locFileProvider.getFullTextRegion(currentSelection);
        int trOffset = tr.getOffset();
        if (trOffset == 0) {
            return null;
        }
        int lineHeight = this.styledText.getLineHeight(trOffset);
        LinkedList<Point> points = new LinkedList<Point>();
        Point lPoint = sPoint = this.styledText.getLocationAtOffset(trOffset);
        int minX = sPoint.x;
        int i = 1;
        while (i <= tr.getLength() && trOffset + i < this.styledText.getCharCount()) {
            Point p = this.styledText.getLocationAtOffset(trOffset + i);
            minX = Math.min(minX, p.x);
            if (p.y != lPoint.y) {
                points.add(lPoint);
                Point lPointNL = new Point(lPoint.x, lPoint.y + lineHeight);
                points.add(lPointNL);
            }
            lPoint = p;
            ++i;
        }
        points.add(lPoint);
        Point lPointNL = new Point(lPoint.x, lPoint.y + lineHeight);
        points.add(lPointNL);
        sPoint.x = minX;
        points.add(0, sPoint);
        Point ePoint = new Point(minX, lPoint.y + lineHeight);
        points.add(ePoint);
        int[] pointArray = new int[2 * points.size()];
        int i2 = 0;
        while (i2 < points.size()) {
            Point p = (Point)points.get(i2);
            pointArray[i2 * 2] = p.x;
            pointArray[i2 * 2 + 1] = p.y;
            ++i2;
        }
        return pointArray;
    }

    public void paintControl(PaintEvent e) {
        for (EObject eo : this.selectedElements) {
            this.paintConture(e, eo, colorBlue);
        }
        if (this.hoveredElement != null) {
            this.paintConture(e, this.hoveredElement, colorGreen);
        }
    }

    private void paintConture(PaintEvent e, EObject currentSelection, Color color) {
        int[] pointArray = this.getConturePointArray(currentSelection);
        if (pointArray != null) {
            e.gc.setForeground(color);
            e.gc.setBackground(color);
            e.gc.drawPolygon(pointArray);
        }
    }
}

