/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysis;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.n4js.flowgraphs.FlowAnalyser;
import org.eclipse.n4js.flowgraphs.N4JSFlowAnalyser;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalkerInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphExplorerInternal;
import org.eclipse.n4js.flowgraphs.analysis.TraverseDirection;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public abstract class GraphVisitorInternal
implements FlowAnalyser {
    protected N4JSFlowAnalyser flowAnalyzer;
    protected final ControlFlowElement container;
    protected final TraverseDirection direction;
    private final List<GraphExplorerInternal> activationRequests = new LinkedList<GraphExplorerInternal>();
    private final List<GraphExplorerInternal> activatedExplorers = new LinkedList<GraphExplorerInternal>();
    private final List<GraphExplorerInternal> activeExplorers = new LinkedList<GraphExplorerInternal>();
    private ControlFlowElement currentContainer;
    private boolean activeMode = false;
    private boolean lastVisitedNodeIsDead = false;

    protected GraphVisitorInternal(TraverseDirection direction) {
        this(null, direction);
    }

    protected GraphVisitorInternal(ControlFlowElement container, TraverseDirection direction) {
        if (direction == null) {
            direction = TraverseDirection.Forward;
        }
        this.direction = direction;
        this.container = container;
    }

    protected void initialize() {
    }

    protected void initializeContainerInternal(ControlFlowElement curContainer) {
    }

    protected void visit(Node node) {
    }

    protected void visit(Node lastVisitNode, Node currentNode, ControlFlowEdge edge) {
    }

    protected void terminateContainer(ControlFlowElement curContainer) {
    }

    protected void terminate() {
    }

    final void setFlowAnalyses(N4JSFlowAnalyser flowAnalyzer) {
        this.flowAnalyzer = flowAnalyzer;
    }

    final void callInitialize() {
        this.initialize();
    }

    final void callInitializeContainerInternal() {
        if (this.activeMode) {
            this.initializeContainerInternal(this.getCurrentContainer());
        }
    }

    final void callTerminateContainer() {
        if (this.activeMode) {
            this.terminateContainer(null);
        }
    }

    final void callTerminate() {
        this.terminate();
    }

    final void callVisit(Node node) {
        if (this.activeMode) {
            this.lastVisitedNodeIsDead = node.isUnreachable();
            this.visit(node);
        }
    }

    final void callVisit(Node lastVisitNode, Node end, ControlFlowEdge edge) {
        if (this.activeMode) {
            this.lastVisitedNodeIsDead = end.isUnreachable();
            this.visit(lastVisitNode, end, edge);
        }
    }

    final void setContainer(ControlFlowElement curContainer) {
        this.currentContainer = curContainer;
        this.checkActive();
    }

    private void checkActive() {
        this.activeMode = this.container == null || this.container == this.currentContainer;
    }

    final List<BranchWalkerInternal> activateRequestedExplorers() {
        LinkedList<BranchWalkerInternal> activatedPaths = new LinkedList<BranchWalkerInternal>();
        for (GraphExplorerInternal app : this.activationRequests) {
            BranchWalkerInternal activePath = app.callFirstBranchWalker(this);
            activatedPaths.add(activePath);
        }
        this.activatedExplorers.addAll(this.activationRequests);
        this.activeExplorers.addAll(this.activationRequests);
        this.activationRequests.clear();
        return activatedPaths;
    }

    final void deactivateGraphExplorer(GraphExplorerInternal pathExplorerInternal) {
        this.activeExplorers.remove(pathExplorerInternal);
    }

    public final void requestActivation(GraphExplorerInternal app) {
        this.activationRequests.add(app);
    }

    public final List<GraphExplorerInternal> getActivatedExplorers() {
        return this.activatedExplorers;
    }

    public final List<GraphExplorerInternal> getActiveExplorers() {
        return this.activeExplorers;
    }

    public final int getActivatedExplorerCount() {
        return this.getActivatedExplorers().size();
    }

    public final int getActiveExplorerCount() {
        return this.getActiveExplorers().size();
    }

    public final TraverseDirection getDirection() {
        return this.direction;
    }

    public final boolean isLiveCode() {
        return !this.lastVisitedNodeIsDead;
    }

    public final boolean isDeadCodeNode() {
        return this.lastVisitedNodeIsDead;
    }

    public final ControlFlowElement getCurrentContainer() {
        return this.currentContainer;
    }

    public final List<GraphExplorerInternal> getPassed() {
        LinkedList<GraphExplorerInternal> passedPEI = new LinkedList<GraphExplorerInternal>();
        for (GraphExplorerInternal pei : this.activatedExplorers) {
            if (!pei.isPassed()) continue;
            passedPEI.add(pei);
        }
        return passedPEI;
    }

    public final List<GraphExplorerInternal> getFailed() {
        LinkedList<GraphExplorerInternal> failedPEI = new LinkedList<GraphExplorerInternal>();
        for (GraphExplorerInternal pei : this.activatedExplorers) {
            if (!pei.isFailed()) continue;
            failedPEI.add(pei);
        }
        return failedPEI;
    }
}

