/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.io;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.log4j.Logger;

public class FileCopier
implements FileVisitor<Path> {
    private static final Logger LOGGER = Logger.getLogger(FileCopier.class);
    private final Path source;
    private final Path target;
    private final Predicate<Path> shouldCopyFile;
    private final boolean logToStdErr;

    private FileCopier(Path source, Path target, Predicate<Path> shouldCopyFile, boolean logToStdErr) {
        this.source = source;
        this.target = target;
        this.shouldCopyFile = shouldCopyFile;
        this.logToStdErr = logToStdErr;
    }

    public static void copy(Path from, Path to) throws IOException {
        FileCopier.copy(from, to, false);
    }

    public static void copy(Path from, Path to, boolean logToStdErr) throws IOException {
        Files.walkFileTree(from, new FileCopier(from, to, (Predicate<Path>)Predicates.alwaysTrue(), logToStdErr));
    }

    public static void copy(Path from, Path to, Predicate<Path> shouldCopyFile) throws IOException {
        Files.walkFileTree(from, new FileCopier(from, to, shouldCopyFile, false));
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        CopyOption[] options = new CopyOption[]{};
        Path newdir = this.target.resolve(this.source.relativize(dir));
        try {
            Files.copy(dir, newdir, options);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            this.logError(newdir, e);
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.shouldCopyFile.apply((Object)file)) {
            Files.copy(file, this.target.resolve(this.source.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        if (exc instanceof FileSystemLoopException) {
            LOGGER.error((Object)("File system loop/cycle detected: " + file), (Throwable)exc);
        } else {
            LOGGER.error((Object)("Error while copying resource: " + file), (Throwable)exc);
        }
        return FileVisitResult.CONTINUE;
    }

    private void logError(Path newdir, IOException e) {
        if (this.logToStdErr) {
            System.err.println("Error while creating folder: " + newdir);
            e.printStackTrace();
        } else {
            LOGGER.error((Object)("Error while creating folder: " + newdir), (Throwable)e);
        }
    }
}

