/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.build;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IEditableModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.Build;
import org.eclipse.pde.internal.core.build.BuildModel;

public class WorkspaceBuildModel
extends BuildModel
implements IEditableModel {
    private static final long serialVersionUID = 1L;
    private IFile fUnderlyingResource;
    private boolean fDirty;
    private boolean fEditable = true;

    public WorkspaceBuildModel(IFile file) {
        this.fUnderlyingResource = file;
    }

    @Override
    public void fireModelChanged(IModelChangedEvent event) {
        this.setDirty(event.getChangeType() != 99);
        super.fireModelChanged(event);
    }

    /*
     * Loose catch block
     */
    public String getContents() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                String string;
                PrintWriter writer;
                StringWriter swriter;
                block18: {
                    swriter = new StringWriter();
                    writer = new PrintWriter(swriter);
                    this.save(writer);
                    writer.flush();
                    string = swriter.toString();
                    if (writer != null) {
                        writer.close();
                    }
                    if (swriter == null) break block18;
                    swriter.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (swriter != null) {
                                swriter.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PDECore.logException(e);
            return "";
        }
    }

    @Override
    public IResource getUnderlyingResource() {
        return this.fUnderlyingResource;
    }

    @Override
    public boolean isDirty() {
        return this.fDirty;
    }

    @Override
    public boolean isEditable() {
        return this.fEditable;
    }

    @Override
    public void load() {
        if (this.fUnderlyingResource.exists()) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream stream = this.fUnderlyingResource.getContents(true);){
                    this.load(stream, false);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                PDECore.logException(e);
            }
        } else {
            this.fBuild = new Build();
            this.fBuild.setModel(this);
            this.setLoaded(true);
        }
    }

    @Override
    public boolean isInSync() {
        return true;
    }

    @Override
    protected void updateTimeStamp() {
        this.updateTimeStamp(this.fUnderlyingResource.getLocation().toFile());
    }

    @Override
    public void save() {
        if (this.fUnderlyingResource == null) {
            return;
        }
        String contents = WorkspaceBuildModel.fixLineDelimiter(this.getContents(), this.fUnderlyingResource);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes(StandardCharsets.ISO_8859_1));){
                if (this.fUnderlyingResource.exists()) {
                    this.fUnderlyingResource.setContents((InputStream)stream, false, false, null);
                } else {
                    this.fUnderlyingResource.create((InputStream)stream, false, null);
                }
                stream.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            PDECore.logException(e);
        }
    }

    @Override
    public void save(PrintWriter writer) {
        this.getBuild().write("", writer);
        this.fDirty = false;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.fDirty = dirty;
    }

    public void setEditable(boolean editable) {
        this.fEditable = editable;
    }

    @Override
    public String getInstallLocation() {
        return this.fUnderlyingResource.getLocation().toOSString();
    }
}

