/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.console;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.n4js.ui.console.N4JSStackTraceHyperlink;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class N4JSExceptionConsoleTracker
implements IPatternMatchListenerDelegate {
    private TextConsole console;
    private final Provider<N4JSStackTraceHyperlink> n4JSStackTraceHyperlinkProvider;

    @Inject
    public N4JSExceptionConsoleTracker(Provider<N4JSStackTraceHyperlink> n4JSStackTraceHyperlinkProvider) {
        this.n4JSStackTraceHyperlinkProvider = n4JSStackTraceHyperlinkProvider;
    }

    public void connect(TextConsole textConsole) {
        this.console = textConsole;
    }

    public void disconnect() {
        this.console = null;
    }

    protected TextConsole getConsole() {
        return this.console;
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            int offset = event.getOffset();
            int length = event.getLength();
            N4JSStackTraceHyperlink link = (N4JSStackTraceHyperlink)this.n4JSStackTraceHyperlinkProvider.get();
            link.setTextConsole(this.console);
            this.console.addHyperlink((IHyperlink)link, offset + 1, length - 2);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

