/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.labeling.helper;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4EnumLiteral;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.resource.N4JSResourceDescriptionStrategy;
import org.eclipse.n4js.ts.types.FieldAccessor;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TEnumLiteral;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ui.labeling.EObjectWithContext;
import org.eclipse.n4js.ui.labeling.N4JSLabelProvider;
import org.eclipse.n4js.ui.labeling.helper.ImageDescriptionHelper;
import org.eclipse.n4js.ui.labeling.helper.ImageFileNameCalculationHelper;
import org.eclipse.n4js.ui.labeling.helper.N4JSImageDescriptionLibrary;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ImageCalculationHelper {
    @Inject
    @Extension
    private ImageDescriptionHelper imageDescriptionHelper;
    @Inject
    @Extension
    private ImageFileNameCalculationHelper imageFileNameCalculationHelper;
    @Extension
    private N4JSImageDescriptionLibrary imageDescriptionLibrary;

    public void setLabelProvider(N4JSLabelProvider provider) {
        this.imageDescriptionHelper.setLabelProvider(provider);
        this.imageDescriptionLibrary = this.imageDescriptionHelper.getImageDescriptionLibrary();
    }

    protected ImageDescriptor _dispatchDoGetImage(Void _null) {
        return null;
    }

    protected ImageDescriptor _dispatchDoGetImage(EObjectWithContext eObjectWithContext) {
        return this.dispatchDoGetImage(eObjectWithContext.obj);
    }

    protected ImageDescriptor _dispatchDoGetImage(N4ClassifierDeclaration n4ClassifierDeclaration) {
        return this.dispatchDoGetImage(n4ClassifierDeclaration.getDefinedType());
    }

    protected ImageDescriptor _dispatchDoGetImage(N4MemberDeclaration n4MemberDeclaration) {
        return this.dispatchDoGetImage(n4MemberDeclaration.getDefinedTypeElement());
    }

    protected ImageDescriptor _dispatchDoGetImage(N4GetterDeclaration getter) {
        return this.dispatchDoGetImage(getter.getDefinedGetter());
    }

    protected ImageDescriptor _dispatchDoGetImage(N4SetterDeclaration setter) {
        return this.dispatchDoGetImage(setter.getDefinedSetter());
    }

    protected ImageDescriptor _dispatchDoGetImage(FunctionDeclaration functionDeclaration) {
        return this.dispatchDoGetImage(functionDeclaration.getDefinedType());
    }

    protected ImageDescriptor _dispatchDoGetImage(ExportedVariableDeclaration variableDeclaration) {
        return this.dispatchDoGetImage(variableDeclaration.getDefinedVariable());
    }

    protected ImageDescriptor _dispatchDoGetImage(ExportedVariableStatement vs) {
        VariableDeclaration firstDecl;
        ImageDescriptor main = this.imageDescriptionHelper.createValidationAwareImageDescriptor((EObject)vs, this.imageFileNameCalculationHelper.getImageFileName(vs));
        EList _varDecl = vs.getVarDecl();
        VariableDeclaration _head = null;
        if (_varDecl != null) {
            _head = (VariableDeclaration)IterableExtensions.head((Iterable)_varDecl);
        }
        if ((firstDecl = _head) != null && firstDecl instanceof ExportedVariableDeclaration && ((ExportedVariableDeclaration)firstDecl).getDefinedVariable() != null) {
            TVariable firstDefinedVariable = ((ExportedVariableDeclaration)firstDecl).getDefinedVariable();
            ImageDescriptor _xifexpression = null;
            boolean _isConst = firstDefinedVariable.isConst();
            if (_isConst) {
                ImageDescriptor _xblockexpression = null;
                ImageDescriptor decorator = this.imageDescriptionLibrary.createConstImageDecorator();
                _xifexpression = _xblockexpression = this.imageDescriptionHelper.createDecorationOverlayIcon(main, decorator, 1);
            } else {
                _xifexpression = main;
            }
            ImageDescriptor newMain = _xifexpression;
            return this.imageDescriptionHelper.addAccessibiltyImageDecorator(newMain, firstDefinedVariable.getTypeAccessModifier());
        }
        return main;
    }

    protected ImageDescriptor _dispatchDoGetImage(N4EnumLiteral n4EnumLiteral) {
        return this.dispatchDoGetImage(n4EnumLiteral.getDefinedLiteral());
    }

    protected ImageDescriptor _dispatchDoGetImage(TClass tClass) {
        ImageDescriptor main = this.imageDescriptionHelper.createValidationAwareImageDescriptor((EObject)tClass, this.imageFileNameCalculationHelper.getImageFileName(tClass));
        boolean _isAbstract = tClass.isAbstract();
        if (_isAbstract) {
            return this.imageDescriptionHelper.createDecorationOverlayIcon(main, this.imageDescriptionLibrary.createAbstractImageDecorator(), 1);
        }
        boolean _isFinal = tClass.isFinal();
        if (_isFinal) {
            return this.imageDescriptionHelper.createDecorationOverlayIcon(main, this.imageDescriptionLibrary.createFinalImageDecorator(), 1);
        }
        return main;
    }

    private ImageDescriptor decorated(ImageDescriptor main, List<ImageDescriptor> decorators) {
        boolean _equals;
        boolean _isEmpty = decorators.isEmpty();
        if (_isEmpty) {
            return main;
        }
        int _size = decorators.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            return this.imageDescriptionHelper.createDecorationOverlayIcon(main, (ImageDescriptor)IterableExtensions.head(decorators), 1);
        }
        return this.imageDescriptionHelper.createDecorationComposite(main, (ImageDescriptor[])Conversions.unwrapArray(decorators, ImageDescriptor.class));
    }

    protected ImageDescriptor _dispatchDoGetImage(TInterface tInterface) {
        ImageDescriptor _xblockexpression = null;
        ImageDescriptor main = this.imageDescriptionHelper.createValidationAwareImageDescriptor((EObject)tInterface, this.imageFileNameCalculationHelper.getImageFileName(tInterface));
        _xblockexpression = this.imageDescriptionHelper.addAccessibiltyImageDecorator(main, tInterface.getTypeAccessModifier());
        return _xblockexpression;
    }

    protected ImageDescriptor _dispatchDoGetImage(TClassifier tClassifier) {
        return this.imageDescriptionHelper.createValidationAwareImageDescriptor((EObject)tClassifier, this.imageFileNameCalculationHelper.getImageFileName(tClassifier));
    }

    protected ImageDescriptor _dispatchDoGetImage(TFunction tFunction) {
        ImageDescriptor _xblockexpression = null;
        ImageDescriptor main = this.imageDescriptionHelper.createValidationAwareImageDescriptor((EObject)tFunction, this.imageFileNameCalculationHelper.getImageFileName(tFunction));
        _xblockexpression = this.imageDescriptionHelper.addAccessibiltyImageDecorator(main, tFunction.getTypeAccessModifier());
        return _xblockexpression;
    }

    protected ImageDescriptor _dispatchDoGetImage(TVariable tVariable) {
        ImageDescriptor _xblockexpression = null;
        ImageDescriptor main = this.imageDescriptionHelper.createValidationAwareImageDescriptor((EObject)tVariable, this.imageFileNameCalculationHelper.getImageFileName(tVariable));
        ImageDescriptor _xifexpression = null;
        boolean _isConst = tVariable.isConst();
        if (_isConst) {
            ImageDescriptor _xblockexpression_1 = null;
            ImageDescriptor decorator = this.imageDescriptionLibrary.createConstImageDecorator();
            _xifexpression = _xblockexpression_1 = this.imageDescriptionHelper.createDecorationOverlayIcon(main, decorator, 1);
        } else {
            _xifexpression = main;
        }
        ImageDescriptor newMain = _xifexpression;
        _xblockexpression = this.imageDescriptionHelper.addAccessibiltyImageDecorator(newMain, tVariable.getTypeAccessModifier());
        return _xblockexpression;
    }

    protected ImageDescriptor _dispatchDoGetImage(TField tField) {
        boolean _isFinal;
        ArrayList decorators = CollectionLiterals.newArrayList();
        boolean _isStatic = tField.isStatic();
        if (_isStatic) {
            ImageDescriptor _createStaticImageDecorator = this.imageDescriptionLibrary.createStaticImageDecorator();
            decorators.add(_createStaticImageDecorator);
        }
        if (_isFinal = tField.isFinal()) {
            ImageDescriptor _createFinalImageDecorator = this.imageDescriptionLibrary.createFinalImageDecorator();
            decorators.add(_createFinalImageDecorator);
        }
        ImageDescriptor main = this.imageDescriptionHelper.createValidationAwareImageDescriptor((EObject)tField, this.imageFileNameCalculationHelper.getImageFileName(tField));
        return this.decorated(main, decorators);
    }

    protected ImageDescriptor _dispatchDoGetImage(TMethod tMethod) {
        boolean _isConstructor;
        boolean _isFinal;
        boolean _isStatic;
        ArrayList decorators = CollectionLiterals.newArrayList();
        boolean _isAbstract = tMethod.isAbstract();
        if (_isAbstract) {
            ImageDescriptor _createAbstractImageDecorator = this.imageDescriptionLibrary.createAbstractImageDecorator();
            decorators.add(_createAbstractImageDecorator);
        }
        if (_isStatic = tMethod.isStatic()) {
            ImageDescriptor _createStaticImageDecorator = this.imageDescriptionLibrary.createStaticImageDecorator();
            decorators.add(_createStaticImageDecorator);
        }
        if (_isFinal = tMethod.isFinal()) {
            ImageDescriptor _createFinalImageDecorator = this.imageDescriptionLibrary.createFinalImageDecorator();
            decorators.add(_createFinalImageDecorator);
        }
        if (_isConstructor = tMethod.isConstructor()) {
            ImageDescriptor _createConstructorImageDecorator = this.imageDescriptionLibrary.createConstructorImageDecorator();
            decorators.add(_createConstructorImageDecorator);
        }
        ImageDescriptor main = this.imageDescriptionHelper.createValidationAwareImageDescriptor((EObject)tMethod, this.imageFileNameCalculationHelper.getImageFileName(tMethod));
        return this.decorated(main, decorators);
    }

    protected ImageDescriptor _dispatchDoGetImage(FieldAccessor tFieldAccessor) {
        boolean _isFinal;
        boolean _isStatic;
        ArrayList decorators = CollectionLiterals.newArrayList();
        boolean _isAbstract = tFieldAccessor.isAbstract();
        if (_isAbstract) {
            ImageDescriptor _createAbstractImageDecorator = this.imageDescriptionLibrary.createAbstractImageDecorator();
            decorators.add(_createAbstractImageDecorator);
        }
        if (_isStatic = tFieldAccessor.isStatic()) {
            ImageDescriptor _createStaticImageDecorator = this.imageDescriptionLibrary.createStaticImageDecorator();
            decorators.add(_createStaticImageDecorator);
        }
        if (_isFinal = tFieldAccessor.isFinal()) {
            ImageDescriptor _createFinalImageDecorator = this.imageDescriptionLibrary.createFinalImageDecorator();
            decorators.add(_createFinalImageDecorator);
        }
        ImageDescriptor _xifexpression = null;
        boolean _isEmpty = decorators.isEmpty();
        if (_isEmpty) {
            _xifexpression = this.imageDescriptionHelper.createValidationAwareImageDescriptor((EObject)tFieldAccessor, this.imageFileNameCalculationHelper.getImageFileName(tFieldAccessor));
        } else {
            ImageDescriptor _xblockexpression = null;
            ImageDescriptor main = this.imageDescriptionHelper.createValidationAwareImageDescriptor((EObject)tFieldAccessor, this.imageFileNameCalculationHelper.getImageFileName(tFieldAccessor));
            _xifexpression = _xblockexpression = this.decorated(main, decorators);
        }
        ImageDescriptor newMain = _xifexpression;
        ImageDescriptor _xifexpression_1 = null;
        if (tFieldAccessor instanceof TSetter) {
            _xifexpression_1 = this.imageDescriptionLibrary.createSetterImageDecorator();
        } else {
            ImageDescriptor _xifexpression_2 = null;
            if (tFieldAccessor instanceof TGetter) {
                _xifexpression_2 = this.imageDescriptionLibrary.createGetterImageDecorator();
            }
            _xifexpression_1 = _xifexpression_2;
        }
        ImageDescriptor fieldAccessorDecorator = _xifexpression_1;
        return this.imageDescriptionHelper.createDecorationOverlayIcon(newMain, fieldAccessorDecorator, 2);
    }

    protected ImageDescriptor _dispatchDoGetImage(TEnumLiteral tEnumLiteral) {
        ArrayList decorators = CollectionLiterals.newArrayList();
        ImageDescriptor _createStaticImageDecorator = this.imageDescriptionLibrary.createStaticImageDecorator();
        decorators.add(_createStaticImageDecorator);
        ImageDescriptor _createFinalImageDecorator = this.imageDescriptionLibrary.createFinalImageDecorator();
        decorators.add(_createFinalImageDecorator);
        ImageDescriptor main = this.imageDescriptionHelper.createValidationAwareImageDescriptor((EObject)tEnumLiteral, this.imageFileNameCalculationHelper.getImageFileName(tEnumLiteral));
        return this.imageDescriptionHelper.createDecorationComposite(main, (ImageDescriptor[])Conversions.unwrapArray((Object)decorators, ImageDescriptor.class));
    }

    protected ImageDescriptor _dispatchDoGetImage(Type type) {
        return this.imageDescriptionHelper.createValidationAwareImageDescriptor((EObject)type, this.imageFileNameCalculationHelper.getImageFileName(type));
    }

    protected ImageDescriptor _dispatchDoGetImage(Keyword keyword) {
        return this.imageDescriptionHelper.createSimpleImageDescriptor(this.imageFileNameCalculationHelper.getImageFileName(keyword));
    }

    protected ImageDescriptor _dispatchDoGetImage(EObject object) {
        if (object instanceof IEObjectDescription && (TypesPackage.eINSTANCE.getTN4Classifier().isSuperTypeOf(((IEObjectDescription)object).getEClass()) || TypesPackage.eINSTANCE.getTEnum().isSuperTypeOf(((IEObjectDescription)object).getEClass()))) {
            EClass _eClass;
            boolean _tripleEquals;
            ImageDescriptor imageDesc = this.imageDescriptionHelper.createSimpleImageDescriptor(this.imageFileNameCalculationHelper.getImageFileName(object));
            EClass _tClass = TypesPackage.eINSTANCE.getTClass();
            boolean bl = _tripleEquals = _tClass == (_eClass = ((IEObjectDescription)object).getEClass());
            if (_tripleEquals) {
                boolean _abstract = N4JSResourceDescriptionStrategy.getAbstract((IEObjectDescription)((IEObjectDescription)object));
                if (_abstract) {
                    return this.imageDescriptionHelper.createDecorationOverlayIcon(imageDesc, this.imageDescriptionLibrary.createAbstractImageDecorator(), 1);
                }
                boolean _final = N4JSResourceDescriptionStrategy.getFinal((IEObjectDescription)((IEObjectDescription)object));
                if (_final) {
                    return this.imageDescriptionHelper.createDecorationOverlayIcon(imageDesc, this.imageDescriptionLibrary.createFinalImageDecorator(), 1);
                }
            }
            return imageDesc;
        }
        return this.imageDescriptionHelper.createValidationAwareImageDescriptor(object, this.imageFileNameCalculationHelper.getImageFileName(object));
    }

    protected ImageDescriptor _dispatchDoGetImage(Object object) {
        return this.imageDescriptionHelper.createSimpleImageDescriptor(this.imageFileNameCalculationHelper.getImageFileName(object));
    }

    public ImageDescriptor dispatchDoGetImage(Object tClass) {
        if (tClass instanceof TClass) {
            return this._dispatchDoGetImage((TClass)tClass);
        }
        if (tClass instanceof TInterface) {
            return this._dispatchDoGetImage((TInterface)tClass);
        }
        if (tClass instanceof TMethod) {
            return this._dispatchDoGetImage((TMethod)tClass);
        }
        if (tClass instanceof TClassifier) {
            return this._dispatchDoGetImage((TClassifier)tClass);
        }
        if (tClass instanceof TFunction) {
            return this._dispatchDoGetImage((TFunction)tClass);
        }
        if (tClass instanceof ExportedVariableDeclaration) {
            return this._dispatchDoGetImage((ExportedVariableDeclaration)tClass);
        }
        if (tClass instanceof N4ClassifierDeclaration) {
            return this._dispatchDoGetImage((N4ClassifierDeclaration)tClass);
        }
        if (tClass instanceof N4GetterDeclaration) {
            return this._dispatchDoGetImage((N4GetterDeclaration)tClass);
        }
        if (tClass instanceof N4SetterDeclaration) {
            return this._dispatchDoGetImage((N4SetterDeclaration)tClass);
        }
        if (tClass instanceof FieldAccessor) {
            return this._dispatchDoGetImage((FieldAccessor)tClass);
        }
        if (tClass instanceof TField) {
            return this._dispatchDoGetImage((TField)tClass);
        }
        if (tClass instanceof ExportedVariableStatement) {
            return this._dispatchDoGetImage((ExportedVariableStatement)tClass);
        }
        if (tClass instanceof FunctionDeclaration) {
            return this._dispatchDoGetImage((FunctionDeclaration)tClass);
        }
        if (tClass instanceof TVariable) {
            return this._dispatchDoGetImage((TVariable)tClass);
        }
        if (tClass instanceof Type) {
            return this._dispatchDoGetImage((Type)tClass);
        }
        if (tClass instanceof TEnumLiteral) {
            return this._dispatchDoGetImage((TEnumLiteral)tClass);
        }
        if (tClass instanceof N4EnumLiteral) {
            return this._dispatchDoGetImage((N4EnumLiteral)tClass);
        }
        if (tClass instanceof N4MemberDeclaration) {
            return this._dispatchDoGetImage((N4MemberDeclaration)tClass);
        }
        if (tClass instanceof Keyword) {
            return this._dispatchDoGetImage((Keyword)tClass);
        }
        if (tClass instanceof EObject) {
            return this._dispatchDoGetImage((EObject)tClass);
        }
        if (tClass == null) {
            return this._dispatchDoGetImage((Void)null);
        }
        if (tClass instanceof EObjectWithContext) {
            return this._dispatchDoGetImage((EObjectWithContext)tClass);
        }
        if (tClass != null) {
            return this._dispatchDoGetImage(tClass);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(tClass).toString());
    }
}

