/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.building;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.n4js.internal.RaceDetectionHelper;
import org.eclipse.n4js.ui.building.BuildDataWithRequestRebuild;
import org.eclipse.n4js.ui.building.BuildManagerAccess;
import org.eclipse.n4js.ui.building.ClosedProjectQueue;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.builder.impl.Messages;
import org.eclipse.xtext.builder.impl.ProjectOpenedOrClosedListener;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.builder.impl.ToBeBuilt;

@Singleton
public class CloseProjectTaskScheduler
extends ProjectOpenedOrClosedListener {
    private final ClosedProjectQueue closedProjectQueue;
    private final RemoveProjectJob removeProjectJob = new RemoveProjectJob("");
    @Inject
    private QueuedBuildData queuedBuildData;

    @Inject
    public CloseProjectTaskScheduler(ClosedProjectQueue closedProjectQueue) {
        this.closedProjectQueue = closedProjectQueue;
    }

    protected void scheduleRemoveProjectJob(IProject project) {
        ToBeBuilt toBeBuilt = this.getToBeBuiltComputer().removeProject(project, (IProgressMonitor)new NullProgressMonitor());
        if (toBeBuilt.getToBeDeleted().isEmpty() && toBeBuilt.getToBeUpdated().isEmpty()) {
            return;
        }
        this.scheduleJob(project.getName(), toBeBuilt);
    }

    private void scheduleJob(String name, ToBeBuilt toBeBuilt) {
        RaceDetectionHelper.log((String)"Enqueue remove project job for %s", (Object)name);
        this.closedProjectQueue.enqueue((Set<String>)ImmutableSet.of((Object)name), toBeBuilt);
        this.removeProjectJob.setName(String.valueOf(Messages.ProjectOpenedOrClosedListener_RemovingProject) + name + Messages.ProjectOpenedOrClosedListener_FromIndex);
        this.removeProjectJob.schedule();
    }

    public void processClosedProjects(IProgressMonitor monitor) {
        ClosedProjectQueue.Task task = this.closedProjectQueue.exhaust();
        if (task.isEmpty()) {
            return;
        }
        String projectNames = Joiner.on((String)", ").join(task.projectNames);
        String taskName = String.valueOf(Messages.ProjectOpenedOrClosedListener_RemovingProject) + projectNames + Messages.ProjectOpenedOrClosedListener_FromIndex;
        RaceDetectionHelper.log((String)taskName, (Object[])new Object[0]);
        monitor.setTaskName(taskName);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            try {
                ResourceSet resourceSet = this.getResourceSetProvider().get(null);
                resourceSet.getLoadOptions().put("org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE", Boolean.TRUE);
                if (resourceSet instanceof ResourceSetImpl) {
                    ((ResourceSetImpl)resourceSet).setURIResourceMap((Map)Maps.newHashMap());
                }
                BuildDataWithRequestRebuild buildData = new BuildDataWithRequestRebuild(projectNames, resourceSet, task.toBeBuilt, this.queuedBuildData, BuildManagerAccess::needBuild);
                this.getBuilderState().update((BuildData)buildData, (IProgressMonitor)progress.newChild(1));
            }
            catch (Error | RuntimeException e) {
                task.reschedule();
                throw e;
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinRemoveProjectJob() {
        try {
            CloseProjectTaskScheduler closeProjectTaskScheduler = this;
            synchronized (closeProjectTaskScheduler) {
                ((Object)((Object)this)).wait(1L);
            }
            this.removeProjectJob.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private final class RemoveProjectJob
    extends WorkspaceJob {
        private RemoveProjectJob(String name) {
            super(name);
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        public boolean belongsTo(Object family) {
            return family == ResourcesPlugin.FAMILY_AUTO_BUILD;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            CloseProjectTaskScheduler.this.processClosedProjects(monitor);
            return Status.OK_STATUS;
        }
    }
}

