/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.containers;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.utils.resources.ExternalFile;
import org.eclipse.xtext.ui.resource.FileStoreStorage;
import org.eclipse.xtext.ui.resource.Storage2UriMapperImpl;
import org.eclipse.xtext.ui.resource.UriValidator;
import org.eclipse.xtext.util.Pair;

@Singleton
public class N4JSStorage2UriMapper
extends Storage2UriMapperImpl {
    @Inject
    private UriValidator uriValidator;

    public Iterable<Pair<IStorage, IProject>> getStorages(URI uri) {
        return Iterables.filter((Iterable)super.getStorages(uri), pair -> pair == null || !(pair.getFirst() instanceof FileStoreStorage));
    }

    public URI getUri(IStorage storage) {
        if (!this.uriValidator.isPossiblyManaged(storage)) {
            return null;
        }
        URI uri = this.internalGetUri(storage);
        if (uri == null) {
            uri = super.getUri(storage);
        }
        if (uri != null && this.isValidUri(uri, storage)) {
            return uri;
        }
        return null;
    }

    private URI internalGetUri(IStorage storage) {
        if (storage instanceof IFile) {
            if (storage instanceof ExternalFile) {
                File externalResource = ((ExternalFile)storage).getExternalResource();
                if (externalResource.isFile()) {
                    return URI.createFileURI((String)externalResource.getAbsolutePath());
                }
            } else {
                return URI.createPlatformResourceURI((String)storage.getFullPath().toString(), (boolean)true);
            }
        }
        return null;
    }
}

