/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.common.unicode.generator;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.eclipse.n4js.common.unicode.CharTypes;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;

public class UnicodeGrammarGenerator {
    public static void main(String[] args) throws IOException {
        new UnicodeGrammarGenerator();
    }

    public UnicodeGrammarGenerator() throws IOException {
        CharSequence _generateUnicodeRules = UnicodeGrammarGenerator.generateUnicodeRules();
        File _file = new File("grammar-gen/org/eclipse/n4js/common/unicode/Unicode.xtext");
        Files.write((CharSequence)_generateUnicodeRules, (File)_file, (Charset)Charsets.UTF_8);
    }

    public static CharSequence generateUnicodeRules() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Copyright (c) 2016 NumberFour AG.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* All rights reserved. This program and the accompanying materials");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* are made available under the terms of the Eclipse Public License v1.0");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* which accompanies this distribution, and is available at");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* http://www.eclipse.org/legal/epl-v10.html");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Contributors:");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*   NumberFour AG - Initial API and implementation");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// Important note:");
        _builder.newLine();
        _builder.append("// This grammar is auto generated by the");
        _builder.newLine();
        _builder.append("// org.eclipse.n4js.common.unicode.generator.UnicodeGrammarGenerator");
        _builder.newLine();
        _builder.append("//");
        _builder.newLine();
        _builder.append("// Rather than editing this manually, update the generator instead!");
        _builder.newLine();
        _builder.newLine();
        _builder.append("grammar org.eclipse.n4js.common.unicode.Unicode");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import \"http://www.eclipse.org/emf/2002/Ecore\" as ecore");
        _builder.newLine();
        _builder.newLine();
        _builder.append("terminal fragment HEX_DIGIT:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("(DECIMAL_DIGIT_FRAGMENT|'a'..'f'|'A'..'F')");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.append("terminal fragment DECIMAL_INTEGER_LITERAL_FRAGMENT:");
        _builder.newLine();
        _builder.append("\t  ");
        _builder.append("'0'");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("| '1'..'9' DECIMAL_DIGIT_FRAGMENT*");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.append("terminal fragment DECIMAL_DIGIT_FRAGMENT:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("'0'..'9'");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.append("terminal fragment ZWJ:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("'\\u200D'");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.append("terminal fragment ZWNJ:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("'\\u200C'");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.append("terminal fragment BOM:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("'\\uFEFF'");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.append("terminal fragment WHITESPACE_FRAGMENT:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("'\\u0009' | '\\u000B' | '\\u000C' | '\\u0020' | '\\u00A0' | BOM | UNICODE_SPACE_SEPARATOR_FRAGMENT");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.append("terminal fragment LINE_TERMINATOR_FRAGMENT:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("'\\u000A' | '\\u000D' | '\\u2028' | '\\u2029'");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.append("terminal fragment LINE_TERMINATOR_SEQUENCE_FRAGMENT:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("'\\u000A' | '\\u000D' '\\u000A'? | '\\u2028' | '\\u2029'");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.append("terminal fragment SL_COMMENT_FRAGMENT:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("'//' (!LINE_TERMINATOR_FRAGMENT)*");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.append("terminal fragment ML_COMMENT_FRAGMENT:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("'/*' -> '*/'");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        _builder.newLine();
        _builder.append("terminal fragment UNICODE_COMBINING_MARK_FRAGMENT:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// any character in the Unicode categories");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// \u2015Non-spacing mark (Mn)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// \u2015Combining spacing mark (Mc)");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function = it -> CharTypes.isCombiningMark(it);
        StringWriter _generateUnicodeRules = UnicodeGrammarGenerator.generateUnicodeRules((Functions.Function1<? super Integer, ? extends Boolean>)_function);
        _builder.append((Object)_generateUnicodeRules, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append(";");
        _builder.newLine();
        _builder.append("terminal fragment UNICODE_DIGIT_FRAGMENT:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// any character in the Unicode categories");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// \u2015Decimal number (Nd)");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_1 = it -> CharTypes.isDigit(it);
        StringWriter _generateUnicodeRules_1 = UnicodeGrammarGenerator.generateUnicodeRules((Functions.Function1<? super Integer, ? extends Boolean>)_function_1);
        _builder.append((Object)_generateUnicodeRules_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append(";");
        _builder.newLine();
        _builder.append("terminal fragment UNICODE_CONNECTOR_PUNCTUATION_FRAGMENT:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// any character in the Unicode categories");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// \u2015Connector punctuation (Pc)");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_2 = it -> CharTypes.isConnectorPunctuation(it);
        StringWriter _generateUnicodeRules_2 = UnicodeGrammarGenerator.generateUnicodeRules((Functions.Function1<? super Integer, ? extends Boolean>)_function_2);
        _builder.append((Object)_generateUnicodeRules_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append(";");
        _builder.newLine();
        _builder.append("terminal fragment UNICODE_LETTER_FRAGMENT:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// any character in the Unicode categories");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// \u2015Uppercase letter (Lu)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// \u2015Lowercase letter (Ll)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// \u2015Titlecase letter (Lt)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// \u2015Modifier letter (Lm)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// \u2015Other letter (Lo)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// \u2015Letter number (Nl)");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_3 = it -> CharTypes.isLetter(it);
        StringWriter _generateUnicodeRules_3 = UnicodeGrammarGenerator.generateUnicodeRules((Functions.Function1<? super Integer, ? extends Boolean>)_function_3);
        _builder.append((Object)_generateUnicodeRules_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append(";");
        _builder.newLine();
        _builder.append("terminal fragment UNICODE_SPACE_SEPARATOR_FRAGMENT:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// any character in the Unicode categories");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// \u2015space separator (Zs)");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_4 = it -> CharTypes.isSpaceSeparator(it);
        StringWriter _generateUnicodeRules_4 = UnicodeGrammarGenerator.generateUnicodeRules((Functions.Function1<? super Integer, ? extends Boolean>)_function_4);
        _builder.append((Object)_generateUnicodeRules_4, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append(";");
        _builder.newLine();
        _builder.append("terminal fragment ANY_OTHER:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".");
        _builder.newLine();
        _builder.append(";");
        _builder.newLine();
        return _builder;
    }

    public static StringWriter generateUnicodeRules(Functions.Function1<? super Integer, ? extends Boolean> guard) {
        Character prev = null;
        boolean run = false;
        boolean first = true;
        char c = '\u0000';
        StringWriter result = new StringWriter();
        PrintWriter printer = new PrintWriter((Writer)result, true);
        do {
            boolean _equals;
            Boolean _apply;
            if ((_apply = (Boolean)guard.apply((Object)c)).booleanValue()) {
                if (run) continue;
                prev = Character.valueOf(c);
                run = true;
                continue;
            }
            if (!run) continue;
            if (!first) {
                printer.print("| ");
            } else {
                printer.print("  ");
                first = false;
            }
            String _padStart = Strings.padStart((String)Integer.toHexString(prev.charValue()).toUpperCase(), (int)4, (char)'0');
            String _plus = "'\\u" + _padStart;
            String _plus_1 = String.valueOf(_plus) + "'";
            printer.print(_plus_1);
            char _charValue = prev.charValue();
            boolean bl = _equals = _charValue == c - '\u0001';
            if (_equals) {
                printer.println();
            } else {
                String _padStart_1 = Strings.padStart((String)Integer.toHexString(c - '\u0001').toUpperCase(), (int)4, (char)'0');
                String _plus_2 = "..'\\u" + _padStart_1;
                String _plus_3 = String.valueOf(_plus_2) + "'";
                printer.println(_plus_3);
            }
            prev = null;
            run = false;
        } while ((c = (char)(c + '\u0001')) != 65535);
        return result;
    }
}

