/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;

@Singleton
public class ExternalProjectsCollector {
    @Inject
    private ExternalLibraryWorkspace extWS;
    @Inject
    private IN4JSCore core;

    public <P extends IProject> Set<P> filterWSProjects(Iterable<P> addedProjects) {
        return this.filterWSProjects(addedProjects, true);
    }

    public <P extends IProject> Set<P> filterNonWSProjects(Iterable<P> projects) {
        return this.filterWSProjects(projects, false);
    }

    private <P extends IProject> Set<P> filterWSProjects(Iterable<P> addedProjects, boolean positive) {
        Set<String> eclipseWorkspaceProjectNames = this.getAllEclipseWorkspaceProjectNames();
        HashSet projectsToBuild = Sets.newHashSet();
        for (IProject addedProject : addedProjects) {
            if (positive != eclipseWorkspaceProjectNames.contains(addedProject.getName())) continue;
            projectsToBuild.add(addedProject);
        }
        return projectsToBuild;
    }

    private Set<String> getAllEclipseWorkspaceProjectNames() {
        if (Platform.isRunning()) {
            return FluentIterable.from(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects())).filter(p -> p.isAccessible()).transform(p -> p.getName()).toSet();
        }
        return Collections.emptySet();
    }

    public Collection<IProject> getWSProjectsDependendingOn() {
        return this.getWSProjectsDependendingOn(this.extWS.getProjects());
    }

    public Collection<IProject> getWSProjectsDependendingOn(Iterable<N4JSExternalProject> externalProjects) {
        return this.getProjectsDependendingOn(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()), externalProjects);
    }

    public Collection<N4JSExternalProject> getExtProjectsDependendingOn(Iterable<N4JSExternalProject> externalProjects) {
        return this.getProjectsDependendingOn(this.extWS.getProjects(), externalProjects);
    }

    private <P extends IProject> Collection<P> getProjectsDependendingOn(Iterable<P> wsProjects, Iterable<N4JSExternalProject> externalProjects) {
        if (!Platform.isRunning()) {
            return Collections.emptyList();
        }
        ImmutableSet externalIds = FluentIterable.from(externalProjects).transform(p -> p.getName()).toSet();
        LinkedList<IProject> filteredProjects = new LinkedList<IProject>();
        HashMap<String, IProject> externalsMapping = new HashMap<String, IProject>();
        for (IProject iProject : externalProjects) {
            externalsMapping.put(iProject.getName(), iProject);
        }
        for (IProject iProject : wsProjects) {
            if (iProject instanceof N4JSExternalProject) {
                N4JSExternalProject extPrj = (N4JSExternalProject)iProject;
                for (String eID : extPrj.getAllDirectDependencyIds()) {
                    IProject externalDependency = (IProject)externalsMapping.get(eID);
                    if (externalDependency == null) continue;
                    filteredProjects.add(iProject);
                }
                continue;
            }
            HashSet deps = Sets.newHashSet(this.getDirectExternalDependencyIds(iProject));
            Iterables.retainAll((Iterable)deps, (Collection)externalIds);
            if (Iterables.isEmpty((Iterable)deps)) continue;
            filteredProjects.add(iProject);
        }
        return filteredProjects;
    }

    public Multimap<N4JSExternalProject, IProject> getWSProjectDependents() {
        return this.getWSProjectDependents(this.extWS.getProjects());
    }

    public Multimap<N4JSExternalProject, IProject> getWSProjectDependents(Iterable<N4JSExternalProject> externalProjects) {
        return this.getProjectDependents(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()), externalProjects);
    }

    public Multimap<N4JSExternalProject, N4JSExternalProject> getExtProjectDependents(Iterable<N4JSExternalProject> externalProjects) {
        return this.getProjectDependents(this.extWS.getProjects(), externalProjects);
    }

    private <P extends IProject> Multimap<N4JSExternalProject, P> getProjectDependents(Iterable<P> wsProjects, Iterable<N4JSExternalProject> externalProjects) {
        HashMultimap mapping = HashMultimap.create();
        if (!Platform.isRunning()) {
            return mapping;
        }
        HashMap<String, N4JSExternalProject> externalsMapping = new HashMap<String, N4JSExternalProject>();
        for (N4JSExternalProject prj : externalProjects) {
            externalsMapping.put(prj.getName(), prj);
        }
        for (N4JSExternalProject prj : wsProjects) {
            if (prj instanceof N4JSExternalProject) {
                N4JSExternalProject extPrj = prj;
                for (String eID : extPrj.getAllDirectDependencyIds()) {
                    N4JSExternalProject externalDependency = (N4JSExternalProject)((Object)externalsMapping.get(eID));
                    if (externalDependency == null) continue;
                    mapping.put((Object)externalDependency, (Object)prj);
                }
                continue;
            }
            for (String eID : this.getDirectExternalDependencyIds((IProject)prj)) {
                N4JSExternalProject externalDependency = (N4JSExternalProject)((Object)externalsMapping.get(eID));
                if (externalDependency == null) continue;
                mapping.put((Object)externalDependency, (Object)prj);
            }
        }
        return mapping;
    }

    private Iterable<String> getDirectExternalDependencyIds(IProject project) {
        if (project == null || !project.isAccessible()) {
            return Collections.emptyList();
        }
        IN4JSProject n4Project = (IN4JSProject)this.core.findProject(URI.createPlatformResourceURI((String)project.getName(), (boolean)true)).orNull();
        if (n4Project == null || !n4Project.exists() || n4Project.isExternal()) {
            return Collections.emptyList();
        }
        return FluentIterable.from(n4Project.getAllDirectDependencies()).filter(IN4JSProject.class).filter(p -> p.isExternal()).transform(p -> p.getProjectName());
    }
}

