/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.N4JSLanguageConstants;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FieldAccessor;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.GetterDeclaration;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.SetterDeclaration;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TStructSetter;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.VoidType;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.n4js.utils.N4JSLanguageHelper;
import org.eclipse.n4js.utils.nodemodel.HiddenLeafAccess;
import org.eclipse.n4js.utils.nodemodel.HiddenLeafs;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.n4js.validation.helper.FunctionValidationHelper;
import org.eclipse.n4js.validation.validators.StaticPolyfillValidatorExtension;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class N4JSFunctionValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private TypeSystemHelper tsh;
    @Inject
    private HiddenLeafAccess hla;
    @Inject
    private N4JSLanguageHelper languageHelper;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkFunctionExpressionInExpressionStatement(FunctionDeclaration functionDeclaration) {
        EObject container = functionDeclaration.eContainer();
        if (container instanceof Block && this.jsVariantHelper.requireCheckFunctionExpressionInExpressionStatement((EObject)functionDeclaration)) {
            boolean _tripleNotEquals;
            String msg = IssueCodes.getMessageForFUN_BLOCK();
            String _name = functionDeclaration.getName();
            boolean bl = _tripleNotEquals = _name != null;
            if (_tripleNotEquals) {
                this.addIssue(msg, (EObject)functionDeclaration, (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DECLARATION__NAME, "FUN_BLOCK", new String[0]);
            } else {
                this.addIssue(msg, container, (EStructuralFeature)functionDeclaration.eContainmentFeature(), "FUN_BLOCK", new String[0]);
            }
        }
    }

    @Check
    public boolean checkSetter(SetterDeclaration setterDeclaration) {
        return this.holdsFunctionReturnsVoid((FunctionOrFieldAccessor)setterDeclaration, true);
    }

    private boolean holdsFunctionReturnsVoid(FunctionOrFieldAccessor functionOrFieldAccessor, boolean isSetter) {
        Iterable<ReturnStatement> retstatements = this.allReturnstatementsAsList(functionOrFieldAccessor);
        VoidType _void = RuleEnvironmentExtensions.voidType(RuleEnvironmentExtensions.newRuleEnvironment((EObject)functionOrFieldAccessor));
        for (ReturnStatement rst : retstatements) {
            boolean _tripleNotEquals;
            Expression _expression = rst.getExpression();
            boolean bl = _tripleNotEquals = _expression != null;
            if (!_tripleNotEquals) continue;
            TypeRef expressionType = this.ts.tau((TypableElement)rst.getExpression());
            Object _xifexpression = null;
            _xifexpression = expressionType instanceof ParameterizedTypeRef ? ((ParameterizedTypeRef)expressionType).getDeclaredType() : expressionType;
            TypeRef actualType = _xifexpression;
            if (actualType == null || Objects.equal((Object)actualType, (Object)_void) || !isSetter) continue;
            String msg = IssueCodes.getMessageForFUN_RETURNTYPE_VOID_FOR_SETTER_VIOLATED();
            this.addIssue(msg, (EObject)rst, "FUN_RETURNTYPE_VOID_FOR_SETTER_VIOLATED");
            return false;
        }
        return true;
    }

    @Check
    public boolean checkFunctionName(FunctionDefinition definition) {
        boolean _isNullOrEmpty;
        boolean _not;
        String name = Strings.nullToEmpty((String)definition.getName());
        String desc = this.validatorMessageHelper.description((EObject)definition);
        String errorMessage = "";
        boolean _requireCheckFunctionName = this.jsVariantHelper.requireCheckFunctionName((EObject)definition);
        if (_requireCheckFunctionName && Boolean.valueOf(definition instanceof N4MethodDeclaration) == Boolean.valueOf(false)) {
            boolean _contains = N4JSLanguageConstants.FUTURE_RESERVED_WORDS.contains(name);
            if (_contains) {
                errorMessage = IssueCodes.getMessageForFUN_NAME_RESERVED(desc, "future reserved word");
            }
            if (!Objects.equal((Object)"yield", (Object)name) && this.languageHelper.getECMAKeywords().contains(name)) {
                errorMessage = IssueCodes.getMessageForFUN_NAME_RESERVED(desc, "keyword");
            }
        }
        boolean bl = _not = !(_isNullOrEmpty = Strings.isNullOrEmpty((String)errorMessage));
        if (_not) {
            EAttribute _switchResult = null;
            boolean _matched = false;
            if (definition instanceof FunctionDeclaration) {
                _matched = true;
                _switchResult = N4JSPackage.Literals.FUNCTION_DECLARATION__NAME;
            }
            if (!_matched && definition instanceof N4MethodDeclaration) {
                _matched = true;
                _switchResult = N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME;
            }
            if (!_matched && definition instanceof FunctionExpression) {
                _matched = true;
                _switchResult = N4JSPackage.Literals.FUNCTION_EXPRESSION__NAME;
            }
            if (!_matched) {
                _switchResult = null;
            }
            EAttribute feature = _switchResult;
            this.addIssue(org.eclipse.xtext.util.Strings.toFirstUpper((String)errorMessage), (EObject)definition, (EStructuralFeature)feature, "FUN_NAME_RESERVED", new String[0]);
        }
        return Strings.isNullOrEmpty((String)errorMessage);
    }

    private Iterable<ReturnStatement> allReturnstatementsAsList(FunctionOrFieldAccessor functionOrFieldAccessor) {
        boolean _tripleEquals;
        List _xifexpression = null;
        Block _body = functionOrFieldAccessor.getBody();
        boolean bl = _tripleEquals = _body == null;
        if (_tripleEquals) {
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        } else {
            com.google.common.base.Predicate _function = it -> !(it instanceof Expression) && !(it instanceof FunctionOrFieldAccessor);
            _xifexpression = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)EcoreUtilN4.getAllContentsFiltered((EObject)functionOrFieldAccessor.getBody(), (com.google.common.base.Predicate)_function), ReturnStatement.class));
        }
        List retsByEcore = _xifexpression;
        return retsByEcore;
    }

    @Check
    public boolean checkReturnExpression(ReturnStatement retStmt) {
        boolean _not;
        FunctionOrFieldAccessor fofa = (FunctionOrFieldAccessor)EcoreUtil2.getContainerOfType((EObject)retStmt, FunctionOrFieldAccessor.class);
        boolean _requireCheckFunctionReturn = this.jsVariantHelper.requireCheckFunctionReturn((EObject)fofa);
        boolean bl = _not = !_requireCheckFunctionReturn;
        if (_not) {
            return false;
        }
        if (fofa instanceof SetterDeclaration) {
            return false;
        }
        if (fofa == null) {
            return false;
        }
        boolean _isReturnValueOptional = fofa.isReturnValueOptional();
        if (_isReturnValueOptional) {
            return false;
        }
        VoidType _void = RuleEnvironmentExtensions.voidType(RuleEnvironmentExtensions.newRuleEnvironment((EObject)fofa));
        TypeRef returnTypeRef = this.tsh.getExpectedTypeOfFunctionOrFieldAccessor(null, fofa);
        boolean _xifexpression = false;
        if (fofa instanceof FieldAccessor) {
            _xifexpression = TypeUtils.isOrContainsType((TypeRef)((FieldAccessor)fofa).getDeclaredTypeRef(), (Type)_void);
        } else {
            boolean _xifexpression_1 = false;
            _xifexpression_1 = fofa instanceof FunctionDefinition ? TypeUtils.isOrContainsType((TypeRef)returnTypeRef, (Type)_void) : false;
            _xifexpression = _xifexpression_1;
        }
        boolean isDeclaredVoid = _xifexpression;
        boolean isUndefined = TypeUtils.isUndefined((TypeArgument)returnTypeRef);
        boolean isVoid = TypeUtils.isOrContainsType((TypeRef)returnTypeRef, (Type)_void);
        boolean isComposed = returnTypeRef instanceof ComposedTypeRef && ((ComposedTypeRef)returnTypeRef).getTypeRefs().size() > 1;
        boolean isGetter = fofa instanceof GetterDeclaration;
        if (!isGetter && (isDeclaredVoid || isVoid || isUndefined || isComposed)) {
            return false;
        }
        if (returnTypeRef != null && retStmt.getExpression() == null) {
            String msg = IssueCodes.getMessageForFUN_MISSING_RETURN_EXPRESSION(returnTypeRef.getTypeRefAsString());
            this.addIssue(msg, (EObject)retStmt, "FUN_MISSING_RETURN_EXPRESSION");
            return true;
        }
        return false;
    }

    @Check
    public void checkFunctionDeclarationName(FunctionDeclaration functionDeclaration) {
        boolean _tripleEquals;
        String _name = functionDeclaration.getName();
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            boolean _tripleNotEquals;
            boolean _isDefaultExport;
            EObject container = functionDeclaration.eContainer();
            if (container instanceof ExportDeclaration && (_isDefaultExport = ((ExportDeclaration)container).isDefaultExport())) {
                return;
            }
            Block _body = functionDeclaration.getBody();
            boolean bl2 = _tripleNotEquals = _body != null;
            if (_tripleNotEquals) {
                ICompositeNode firstNode = NodeModelUtils.findActualNodeFor((EObject)functionDeclaration);
                ICompositeNode lastNode = NodeModelUtils.findActualNodeFor((EObject)functionDeclaration.getBody());
                HiddenLeafs hLeafs = this.hla.getHiddenLeafsBefore((INode)lastNode);
                int off = firstNode.getOffset();
                int _offset = hLeafs.getOffset();
                int _offset_1 = firstNode.getOffset();
                int len = _offset - _offset_1;
                this.addIssue(IssueCodes.getMessageForFUN_NAME_MISSING(), (EObject)functionDeclaration, off, len, "FUN_NAME_MISSING");
            } else {
                this.addIssue(IssueCodes.getMessageForFUN_NAME_MISSING(), (EObject)functionDeclaration, "FUN_NAME_MISSING");
            }
        }
    }

    @Check
    public void checkFunctionDeclarationBody(FunctionDeclaration functionDeclaration) {
        if (functionDeclaration.getBody() == null && functionDeclaration.getDefinedType() instanceof TFunction && !((TFunction)functionDeclaration.getDefinedType()).isExternal()) {
            this.addIssue(IssueCodes.getMessageForFUN_BODY(), (EObject)functionDeclaration, (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DECLARATION__NAME, "FUN_BODY", new String[0]);
        }
    }

    @Check
    public void checkParameters(SetterDeclaration fun) {
        boolean _xifexpression = false;
        FormalParameter _fpar = null;
        if (fun != null) {
            _fpar = fun.getFpar();
        }
        boolean _tripleNotEquals = _fpar != null;
        _xifexpression = _tripleNotEquals ? fun.getFpar().isVariadic() : false;
        boolean isVariadic = _xifexpression;
        boolean _xifexpression_1 = false;
        FormalParameter _fpar_1 = null;
        if (fun != null) {
            _fpar_1 = fun.getFpar();
        }
        boolean _tripleNotEquals_1 = _fpar_1 != null;
        _xifexpression_1 = _tripleNotEquals_1 ? fun.getFpar().isHasInitializerAssignment() : false;
        boolean hasInitializerAssignment = _xifexpression_1;
        this.internalCheckSetterParameters(fun.getFpar(), isVariadic, hasInitializerAssignment);
    }

    @Check
    public void checkParameters(TStructSetter fun) {
        boolean _xifexpression = false;
        TFormalParameter _fpar = null;
        if (fun != null) {
            _fpar = fun.getFpar();
        }
        boolean _tripleNotEquals = _fpar != null;
        _xifexpression = _tripleNotEquals ? fun.getFpar().isVariadic() : false;
        boolean isVariadic = _xifexpression;
        boolean _xifexpression_1 = false;
        TFormalParameter _fpar_1 = null;
        if (fun != null) {
            _fpar_1 = fun.getFpar();
        }
        boolean _tripleNotEquals_1 = _fpar_1 != null;
        _xifexpression_1 = _tripleNotEquals_1 ? fun.getFpar().isHasInitializerAssignment() : false;
        boolean hasInitializerAssignment = _xifexpression_1;
        this.internalCheckSetterParameters(fun.getFpar(), isVariadic, hasInitializerAssignment);
    }

    private <T extends EObject> void internalCheckSetterParameters(T fpar, boolean isVariadic, boolean hasInitializerAssignment) {
        if (isVariadic) {
            String msg = IssueCodes.getMessageForFUN_SETTER_CANT_BE_VARIADIC();
            this.addIssue(msg, fpar, "FUN_SETTER_CANT_BE_VARIADIC");
        }
        if (hasInitializerAssignment) {
            String msg_1 = IssueCodes.getMessageForFUN_SETTER_CANT_BE_DEFAULT();
            this.addIssue(msg_1, fpar, "FUN_SETTER_CANT_BE_DEFAULT");
        }
    }

    @Check
    public void checkOptionalModifier(FormalParameter fpar) {
        if (fpar.getDeclaredTypeRef() != null && fpar.getDeclaredTypeRef().isFollowedByQuestionMark()) {
            String msg = IssueCodes.getMessageForFUN_PARAM_OPTIONAL_WRONG_SYNTAX(fpar.getName());
            this.addIssue(msg, (EObject)fpar, "FUN_PARAM_OPTIONAL_WRONG_SYNTAX");
        }
    }

    @Check
    public void checkOptionalModifierT(TFormalParameter fpar) {
        if (fpar.getTypeRef() != null && fpar.getTypeRef().isFollowedByQuestionMark()) {
            TypeRef _typeRef = fpar.getTypeRef();
            Type _declaredType = null;
            if (_typeRef != null) {
                _declaredType = _typeRef.getDeclaredType();
            }
            String _name = null;
            if (_declaredType != null) {
                _name = _declaredType.getName();
            }
            String msg = IssueCodes.getMessageForFUN_PARAM_OPTIONAL_WRONG_SYNTAX(_name);
            this.addIssue(msg, (EObject)fpar, "FUN_PARAM_OPTIONAL_WRONG_SYNTAX");
        }
    }

    @Check
    public void checkFormalParametersIn(FunctionTypeExpression fun) {
        Procedures.Procedure3 _function;
        this.internalCheckOptionalsHaveType((TFormalParameter[])Conversions.unwrapArray((Object)fun.getFpars(), TFormalParameter.class));
        final Procedures.Procedure3 issueConsumer = _function = (msg, id, eObj) -> this.addIssue((String)msg, (EObject)eObj, (String)id);
        Predicate<TFormalParameter> _function_1 = it -> it.isVariadic();
        Predicate<TFormalParameter> _function_2 = it -> it.isHasInitializerAssignment();
        Function<TFormalParameter, String> _function_3 = it -> {
            TypeRef _typeRef = it.getTypeRef();
            Type _declaredType = null;
            if (_typeRef != null) {
                _declaredType = _typeRef.getDeclaredType();
            }
            String _name = null;
            if (_declaredType != null) {
                _name = _declaredType.getName();
            }
            return _name;
        };
        FunctionValidationHelper.internalCheckFormalParameters((EObject[])((TFormalParameter[])Conversions.unwrapArray((Object)fun.getFpars(), TFormalParameter.class)), _function_1, _function_2, _function_3, (FunctionValidationHelper.TripleConsumer)new FunctionValidationHelper.TripleConsumer<String, String, EObject>(){

            @Override
            public void accept(String arg0, String arg1, EObject arg2) {
                issueConsumer.apply((Object)arg0, (Object)arg1, (Object)arg2);
            }
        });
    }

    @Check
    public void checkFormalParametersIn(TFunction fun) {
        Procedures.Procedure3 _function;
        this.internalCheckOptionalsHaveType((TFormalParameter[])Conversions.unwrapArray((Object)fun.getFpars(), TFormalParameter.class));
        final Procedures.Procedure3 issueConsumer = _function = (msg, id, eObj) -> this.addIssue((String)msg, (EObject)eObj, (String)id);
        Predicate<TFormalParameter> _function_1 = it -> it.isVariadic();
        Predicate<TFormalParameter> _function_2 = it -> it.isHasInitializerAssignment();
        Function<TFormalParameter, String> _function_3 = it -> {
            TypeRef _typeRef = it.getTypeRef();
            Type _declaredType = null;
            if (_typeRef != null) {
                _declaredType = _typeRef.getDeclaredType();
            }
            String _name = null;
            if (_declaredType != null) {
                _name = _declaredType.getName();
            }
            return _name;
        };
        FunctionValidationHelper.internalCheckFormalParameters((EObject[])((TFormalParameter[])Conversions.unwrapArray((Object)fun.getFpars(), TFormalParameter.class)), _function_1, _function_2, _function_3, (FunctionValidationHelper.TripleConsumer)new FunctionValidationHelper.TripleConsumer<String, String, EObject>(){

            @Override
            public void accept(String arg0, String arg1, EObject arg2) {
                issueConsumer.apply((Object)arg0, (Object)arg1, (Object)arg2);
            }
        });
    }

    private void internalCheckOptionalsHaveType(TFormalParameter[] fpars) {
        TFormalParameter[] tFormalParameterArray = fpars;
        int n = fpars.length;
        int n2 = 0;
        while (n2 < n) {
            TFormalParameter fp = tFormalParameterArray[n2];
            if (fp.hasASTInitializer() && !"undefined".equals(fp.getAstInitializer())) {
                this.addIssue(IssueCodes.getMessageForFUN_PARAM_INITIALIZER_ONLY_UNDEFINED_ALLOWED(), (EObject)fp, "FUN_PARAM_INITIALIZER_ONLY_UNDEFINED_ALLOWED");
            }
            ++n2;
        }
    }

    @Check
    public void checkFormalParametersIn(FunctionDefinition fun) {
        Procedures.Procedure3 _function;
        this.internalCheckInitializerBindings(fun);
        final Procedures.Procedure3 issueConsumer = _function = (msg, id, eObj) -> this.addIssue((String)msg, (EObject)eObj, (String)id);
        Predicate<FormalParameter> _function_1 = it -> it.isVariadic();
        Predicate<FormalParameter> _function_2 = it -> it.isHasInitializerAssignment();
        Function<FormalParameter, String> _function_3 = it -> it.getName();
        FunctionValidationHelper.internalCheckFormalParameters((EObject[])((FormalParameter[])Conversions.unwrapArray((Object)fun.getFpars(), FormalParameter.class)), _function_1, _function_2, _function_3, (FunctionValidationHelper.TripleConsumer)new FunctionValidationHelper.TripleConsumer<String, String, EObject>(){

            @Override
            public void accept(String arg0, String arg1, EObject arg2) {
                issueConsumer.apply((Object)arg0, (Object)arg1, (Object)arg2);
            }
        });
    }

    private void internalCheckInitializerBindings(FunctionDefinition fun) {
        boolean _tripleEquals;
        Block _body = fun.getBody();
        boolean bl = _tripleEquals = _body == null;
        if (_tripleEquals) {
            return;
        }
        Functions.Function1 _function = it -> EcoreUtil2.eAllOfType((EObject)it, IdentifierRef.class);
        Iterator idRefs = Iterables.concat((Iterable)ListExtensions.map((List)fun.getFpars(), (Functions.Function1)_function)).iterator();
        Functions.Function1 _function_1 = it -> it.getName();
        List varDeclNamesInBody = ListExtensions.map((List)EcoreUtil2.eAllOfType((EObject)fun.getBody(), VariableDeclaration.class), (Functions.Function1)_function_1);
        while (idRefs.hasNext()) {
            IdentifierRef idRef = (IdentifierRef)idRefs.next();
            boolean _contains = varDeclNamesInBody.contains(idRef.getId().getName());
            if (!_contains) continue;
            FormalParameter fpar = (FormalParameter)EcoreUtil2.getContainerOfType((EObject)idRef, FormalParameter.class);
            String msg = IssueCodes.getMessageForFUN_PARAM_INITIALIZER_ILLEGAL_REFERENCE_TO_BODY_VARIABLE(fpar.getName(), idRef.getId().getName());
            this.addIssue(msg, (EObject)idRef, "FUN_PARAM_INITIALIZER_ILLEGAL_REFERENCE_TO_BODY_VARIABLE");
        }
    }

    public void holdsModifierOfParamsHaveType(EList<FormalParameter> list) {
        for (FormalParameter fp : list) {
            boolean _isVariadic;
            boolean _isHasInitializerAssignment = fp.getDefinedTypeElement().isHasInitializerAssignment();
            if (!_isHasInitializerAssignment || !(_isVariadic = fp.isVariadic())) continue;
            this.addIssue(IssueCodes.getMessageForFUN_PARAM_VARIADIC_WITH_INITIALIZER(), (EObject)fp, "FUN_PARAM_VARIADIC_WITH_INITIALIZER");
        }
    }

    public void holdsModifierOfParamsHaveTType(List<TFormalParameter> list) {
        for (TFormalParameter fp : list) {
            boolean _isVariadic;
            boolean _isHasInitializerAssignment = fp.isHasInitializerAssignment();
            if (!_isHasInitializerAssignment || !(_isVariadic = fp.isVariadic())) continue;
            this.addIssue(IssueCodes.getMessageForFUN_PARAM_VARIADIC_WITH_INITIALIZER(), (EObject)fp, "FUN_PARAM_VARIADIC_WITH_INITIALIZER");
        }
    }

    @Check
    public void checkNonVoidAsyncMethod(FunctionDefinition funDef) {
        Type _definedType;
        TypeRef tfunctionRetType;
        boolean _isVoid;
        if (funDef.isAsync() && funDef.getDefinedType() != null && (_isVoid = TypeUtils.isVoid((TypeArgument)(tfunctionRetType = ((TFunction)(_definedType = funDef.getDefinedType())).getReturnTypeRef())))) {
            String message = IssueCodes.getMessageForTYS_NON_VOID_ASYNC();
            this.addIssue(message, (EObject)funDef, "TYS_NON_VOID_ASYNC");
        }
    }

    @Check
    public void checkNoThisAsyncMethod(FunctionDefinition funDef) {
        boolean _isOrContainsThisType;
        boolean _isAsync = funDef.isAsync();
        if (_isAsync && (_isOrContainsThisType = TypeUtils.isOrContainsThisType((TypeRef)funDef.getReturnTypeRef()))) {
            String message = IssueCodes.getMessageForTYS_NON_THIS_ASYNC();
            this.addIssue(message, (EObject)funDef, "TYS_NON_THIS_ASYNC");
        }
    }

    public void addIssue(String message, EObject source, EStructuralFeature feature, String issueCode, String ... issueData) {
        super.addIssue(message, source, feature, issueCode, issueData);
    }

    @Check
    public void checkFunctionDeclarationInStaticPolyfillModule(FunctionDeclaration functionDeclaration) {
        StaticPolyfillValidatorExtension.internalCheckNotInStaticPolyfillModule(functionDeclaration, this);
    }

    @Check
    public void checkNoUnusedTypeParameters(FunctionDeclaration functionDeclaration) {
        this.internalCheckNoUnusedTypeParameters(functionDeclaration);
    }

    @Check
    public void checkNoUnusedTypeParameters(FunctionExpression functionExpression) {
        this.internalCheckNoUnusedTypeParameters(functionExpression);
    }

    @Check
    public void checkNoUnusedTypeParameters(FunctionTypeExpression functionTypeExp) {
        this.internalCheckNoUnusedTypeParameters(functionTypeExp);
    }
}

