/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators.flowgraphs;

import com.google.common.base.Strings;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.FlowAnalyser;
import org.eclipse.n4js.flowgraphs.analysers.DeadCodeAnalyser;
import org.eclipse.n4js.n4JS.BreakStatement;
import org.eclipse.n4js.n4JS.ContinueStatement;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.ThrowStatement;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.N4JSElementKeywordProvider;
import org.eclipse.n4js.validation.validators.N4JSFlowgraphValidator;
import org.eclipse.n4js.validation.validators.flowgraphs.FlowValidator;

public class DeadCodeValidator
implements FlowValidator {
    private final DeadCodeAnalyser dca;
    private final N4JSElementKeywordProvider keywordProvider;

    public DeadCodeValidator(N4JSElementKeywordProvider keywordProvider) {
        this.keywordProvider = keywordProvider;
        this.dca = new DeadCodeAnalyser();
    }

    @Override
    public FlowAnalyser getFlowAnalyser() {
        return this.dca;
    }

    @Override
    public void checkResults(N4JSFlowgraphValidator fVali) {
        this.internalCheckDeadCode(fVali);
    }

    private void internalCheckDeadCode(N4JSFlowgraphValidator fVali) {
        Set deadCodeRegions = this.dca.getDeadCodeRegions();
        for (DeadCodeAnalyser.DeadCodeRegion dcRegion : deadCodeRegions) {
            String stmtDescription = this.getStatementDescription(dcRegion);
            String errCode = "FUN_DEAD_CODE";
            String msg = IssueCodes.getMessageForFUN_DEAD_CODE();
            if (stmtDescription != null) {
                msg = IssueCodes.getMessageForFUN_DEAD_CODE_WITH_PREDECESSOR(stmtDescription);
                errCode = "FUN_DEAD_CODE_WITH_PREDECESSOR";
            }
            fVali.addIssue(msg, (EObject)dcRegion.getContainer(), dcRegion.getOffset(), dcRegion.getLength(), errCode);
        }
    }

    private String getStatementDescription(DeadCodeAnalyser.DeadCodeRegion deadCodeRegion) {
        ControlFlowElement reachablePred = deadCodeRegion.getReachablePredecessor();
        if (reachablePred == null) {
            return null;
        }
        boolean addKeyword = false;
        addKeyword |= reachablePred instanceof ReturnStatement;
        addKeyword |= reachablePred instanceof BreakStatement;
        addKeyword |= reachablePred instanceof ContinueStatement;
        if (addKeyword |= reachablePred instanceof ThrowStatement) {
            String keyword = this.keywordProvider.keyword(reachablePred);
            if (Strings.isNullOrEmpty((String)keyword)) {
                keyword = reachablePred.eClass().getName();
            }
            return keyword;
        }
        return null;
    }
}

