/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.nodejs.ui.launch;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.n4js.runner.SystemLoaderInfo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class NodejsLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private Text optionsText;
    private Text environmentVariablesText;
    private Text customPathText;
    private ComboViewer systemLoaderCombo;

    public static String mapToString(Map<String, String> map) {
        String _xblockexpression = null;
        if (map == null) {
            return "";
        }
        Comparator _function = (o1, o2) -> ((String)o1.getKey()).compareTo((String)o2.getKey());
        Functions.Function1 _function_1 = it -> {
            String _key = (String)it.getKey();
            String _plus = String.valueOf(_key) + "=";
            String _value = (String)it.getValue();
            return String.valueOf(_plus) + _value;
        };
        _xblockexpression = IterableExtensions.join((Iterable)IterableExtensions.sortWith(map.entrySet(), (Comparator)_function), (CharSequence)"\n", (Functions.Function1)_function_1);
        return _xblockexpression;
    }

    public static Map<String, String> stringToMap(String text) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (text != null) {
            Consumer<String> _function = it -> {
                boolean _not;
                String line = it.trim();
                boolean _isEmpty = line.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    boolean _notEquals;
                    String[] keyVal = line.split("=");
                    int _length = keyVal.length;
                    boolean bl2 = _notEquals = _length != 2;
                    if (_notEquals) {
                        throw new IllegalArgumentException("Env. vars are expected to be saved in lines with key=val; found: " + line);
                    }
                    map.put(keyVal[0].trim(), keyVal[1].trim());
                }
            };
            ((List)Conversions.doWrapArray((Object)text.split("\n"))).forEach(_function);
        }
        return map;
    }

    public void createControl(Composite parent) {
        Composite _composite = new Composite(parent, 0);
        Procedures.Procedure1 _function = it -> {
            it.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
            it.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).align(4, 4).create());
        };
        Composite childControl = (Composite)ObjectExtensions.operator_doubleArrow((Object)_composite, (Procedures.Procedure1)_function);
        this.customPathText = this.createGroupWithMultiText(childControl, "NODE_PATH");
        this.optionsText = this.createGroupWithMultiText(childControl, "Node.js options");
        this.environmentVariablesText = this.createGroupWithMultiText(childControl, "Environment Variables (VAR=...)");
        this.systemLoaderCombo = this.createGroupWithComboViewer(childControl, "System loader");
        this.systemLoaderCombo.setInput((Object)SystemLoaderInfo.values());
        this.setControl((Control)childControl);
    }

    public String getName() {
        return "Node.js settings";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.optionsText.setText(configuration.getAttribute("ENGINE_OPTIONS", ""));
            this.environmentVariablesText.setText(NodejsLaunchConfigurationTab.mapToString(configuration.getAttribute("ENV_VARS", Collections.emptyMap())));
            this.customPathText.setText(configuration.getAttribute("CUSTOM_ENGINE_PATH", ""));
            SystemLoaderInfo systemLoader = SystemLoaderInfo.fromString((String)configuration.getAttribute("SYSTEM_LOADER", ""));
            SystemLoaderInfo _xifexpression = null;
            _xifexpression = systemLoader == null ? SystemLoaderInfo.SYSTEM_JS : systemLoader;
            StructuredSelection _structuredSelection = new StructuredSelection((Object)_xifexpression);
            this.systemLoaderCombo.setSelection((ISelection)_structuredSelection);
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                CoreException e = (CoreException)_t;
                this.setErrorMessage(e.getMessage());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Object firstElement;
        configuration.setAttribute("ENGINE_OPTIONS", Strings.nullToEmpty((String)this.optionsText.getText()));
        configuration.setAttribute("ENV_VARS", NodejsLaunchConfigurationTab.stringToMap(this.environmentVariablesText.getText()));
        configuration.setAttribute("CUSTOM_ENGINE_PATH", Strings.nullToEmpty((String)this.customPathText.getText()));
        ISelection selection = this.systemLoaderCombo.getSelection();
        SystemLoaderInfo systemLoader = SystemLoaderInfo.SYSTEM_JS;
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof SystemLoaderInfo) {
            systemLoader = (SystemLoaderInfo)firstElement;
        }
        configuration.setAttribute("SYSTEM_LOADER", Strings.nullToEmpty((String)systemLoader.getId()));
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("CUSTOM_ENGINE_PATH", "");
        configuration.setAttribute("ENGINE_OPTIONS", "");
        configuration.setAttribute("SYSTEM_LOADER", "");
    }

    private Text createMultiText(Composite parent) {
        Text _text = new Text(parent, 2050);
        Procedures.Procedure1 _function = it -> {
            it.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).align(4, 4).create());
            ModifyListener _function_1 = it_1 -> this.updateLaunchConfigurationDialog();
            it.addModifyListener(_function_1);
        };
        return (Text)ObjectExtensions.operator_doubleArrow((Object)_text, (Procedures.Procedure1)_function);
    }

    private ComboViewer createComboViewer(Composite parent) {
        ComboViewer _comboViewer = new ComboViewer(parent, 2056);
        Procedures.Procedure1 _function = it -> {
            Control _control = it.getControl();
            _control.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).align(4, 4).create());
            it.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            ISelectionChangedListener _function_1 = it_1 -> this.updateLaunchConfigurationDialog();
            it.addSelectionChangedListener(_function_1);
        };
        return (ComboViewer)ObjectExtensions.operator_doubleArrow((Object)_comboViewer, (Procedures.Procedure1)_function);
    }

    private Text createGroupWithMultiText(Composite parent, String groupText) {
        Group _group = new Group(parent, 0);
        Procedures.Procedure1 _function = it -> {
            it.setText(groupText);
            it.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
            it.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).align(4, 4).create());
        };
        Group group = (Group)ObjectExtensions.operator_doubleArrow((Object)_group, (Procedures.Procedure1)_function);
        return this.createMultiText((Composite)group);
    }

    private ComboViewer createGroupWithComboViewer(Composite parent, String groupText) {
        Group _group = new Group(parent, 0);
        Procedures.Procedure1 _function = it -> {
            it.setText(groupText);
            it.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
            it.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).align(4, 4).create());
        };
        Group group = (Group)ObjectExtensions.operator_doubleArrow((Object)_group, (Procedures.Procedure1)_function);
        return this.createComboViewer((Composite)group);
    }
}

