/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.model;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xpect.Member;
import org.eclipse.xpect.XpectIgnore;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.XpectJavaModel;
import org.eclipse.xpect.XpectTest;
import org.eclipse.xpect.model.XpectFileImpl;
import org.eclipse.xpect.model.XpectInvocationImplCustom;
import org.eclipse.xpect.parameter.IStatementRelatedRegion;
import org.eclipse.xpect.registry.ITestSuiteInfo;
import org.eclipse.xpect.registry.LazyClass;
import org.eclipse.xpect.setup.ISetupInitializer;
import org.eclipse.xpect.setup.SetupInitializer;
import org.eclipse.xpect.util.XpectJavaModelManager;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public class XpectFileImplCustom
extends XpectFileImpl {
    private Map<String, XpectInvocation> id2invocation;
    private XpectJavaModel javaModel;

    @Override
    public <T> ISetupInitializer<T> createSetupInitializer() {
        XpectTest test = this.getTest();
        if (test != null && !test.eIsProxy()) {
            return new SetupInitializer(test);
        }
        return new ISetupInitializer.Null();
    }

    private XpectJavaModel findJavaModel() {
        JvmDeclaredType suite;
        XtextResource resource = (XtextResource)this.eResource();
        XtextResourceSet resourceSet = (XtextResourceSet)resource.getResourceSet();
        XpectTest test = this.getTest();
        if (test != null && (suite = test.getDeclaredSuite()) != null) {
            if (suite.eIsProxy()) {
                return null;
            }
            return XpectJavaModelManager.getOrCreate(suite);
        }
        ITestSuiteInfo suiteInfo = ITestSuiteInfo.Registry.INSTANCE.getTestSuite(this.eResource());
        if (suiteInfo == null) {
            return null;
        }
        LazyClass<Object> lazyClass = suiteInfo.getClazz();
        if (lazyClass.getLoader() == null) {
            IJvmTypeProvider iJvmTypeProvider = ((IJvmTypeProvider.Factory)resource.getResourceServiceProvider().get(IJvmTypeProvider.Factory.class)).findOrCreateTypeProvider((ResourceSet)resourceSet);
            JvmType eObject = iJvmTypeProvider.findTypeByName(lazyClass.getName());
            if (eObject instanceof JvmDeclaredType) {
                return XpectJavaModelManager.getOrCreate((JvmDeclaredType)eObject);
            }
        } else {
            Class<Object> clazz = lazyClass.load();
            return XpectJavaModelManager.getOrCreate((ResourceSet)resourceSet, clazz);
        }
        return null;
    }

    @Override
    public String getDocument() {
        return ((XtextResource)this.eResource()).getParseResult().getRootNode().getText();
    }

    @Override
    public XpectInvocation getInvocation(String id) {
        if (this.id2invocation == null) {
            this.initalizeInvocationsIDs();
        }
        return this.id2invocation.get(id);
    }

    @Override
    public XpectInvocation getInvocationAt(int offset) {
        if (offset < 0) {
            return null;
        }
        EList<Member> members = this.getMembers();
        for (Member member : members) {
            if (!(member instanceof XpectInvocation)) continue;
            XpectInvocation invocation = (XpectInvocation)member;
            IStatementRelatedRegion region = invocation.getExtendedRegion();
            int o = region.getOffset();
            int e = o + region.getLength();
            if (o > offset || offset > e) continue;
            return invocation;
        }
        return null;
    }

    @Override
    public Iterable<XpectInvocation> getInvocations() {
        return Iterables.filter(this.getMembers(), XpectInvocation.class);
    }

    @Override
    public XpectJavaModel getJavaModel() {
        if (this.javaModel == null) {
            this.javaModel = this.findJavaModel();
        }
        return this.javaModel;
    }

    @Override
    public XpectTest getTest() {
        return (XpectTest)Iterables.getFirst((Iterable)Iterables.filter(this.getMembers(), XpectTest.class), null);
    }

    public void initalizeInvocationsIDs() {
        HashMap id2invocation = Maps.newHashMap();
        HashMap counter = Maps.newHashMap();
        for (XpectInvocation inv : this.getInvocations()) {
            XpectInvocationImplCustom impl = (XpectInvocationImplCustom)inv;
            String name = impl.getMethodName();
            Integer count = (Integer)counter.get(name);
            count = count == null ? 0 : count + 1;
            counter.put(name, count);
            String id = String.valueOf(name) + "~" + count;
            impl.setId(id);
            id2invocation.put(id, inv);
        }
        this.id2invocation = id2invocation;
    }

    @Override
    public boolean isIgnore() {
        return !Iterables.isEmpty((Iterable)Iterables.filter(this.getMembers(), XpectIgnore.class));
    }

    public void unsetInvocationIDs() {
        if (this.id2invocation != null) {
            this.id2invocation = null;
            for (XpectInvocation inv : this.getInvocations()) {
                ((XpectInvocationImplCustom)inv).setId(null);
            }
        }
    }

    public void unsetJavaModel() {
        this.javaModel = null;
    }
}

