/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.building;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ui.external.ExternalLibraryErrorMarkerManager;
import org.eclipse.n4js.ui.internal.N4JSEclipseProject;
import org.eclipse.xtext.builder.builderState.MarkerUpdaterImpl;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;

public class N4JSMarkerUpdater
extends MarkerUpdaterImpl {
    @Inject
    private IStorage2UriMapper mapper;
    private ExternalLibraryErrorMarkerManager markerManager;
    private IN4JSCore n4jsCore;

    @Inject
    private void injectISharedStateContributionRegistry(ISharedStateContributionRegistry registry) {
        try {
            this.n4jsCore = (IN4JSCore)registry.getSingleContributedInstance(IN4JSCore.class);
            this.markerManager = (ExternalLibraryErrorMarkerManager)registry.getSingleContributedInstance(ExternalLibraryErrorMarkerManager.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateMarkers(IResourceDescription.Delta delta, ResourceSet resourceSet, IProgressMonitor monitor) throws OperationCanceledException {
        Pair pair;
        Resource res;
        URI uri = delta.getUri();
        Resource resource = res = resourceSet != null ? resourceSet.getResource(uri, false) : null;
        if (res instanceof N4JSResource && ((N4JSResource)res).isOpaque()) {
            return;
        }
        Iterable pairs = this.mapper.getStorages(uri);
        if (resourceSet != null && pairs.iterator().hasNext() && !((pair = (Pair)pairs.iterator().next()).getFirst() instanceof IFile)) {
            this.updateMarkersForExternalLibraries(delta, resourceSet, monitor);
            return;
        }
        super.updateMarkers(delta, resourceSet, monitor);
    }

    private void updateMarkersForExternalLibraries(IResourceDescription.Delta delta, ResourceSet resourceSet, IProgressMonitor monitor) {
        URI uri = delta.getUri();
        if (this.n4jsCore.isNoValidate(uri)) {
            return;
        }
        Resource resource = resourceSet.getResource(uri, true);
        IResourceValidator validator = this.getValidator(resource);
        IN4JSProject prj = (IN4JSProject)this.n4jsCore.findProject(uri).orNull();
        CancelIndicator cancelIndicator = this.getCancelIndicator(monitor);
        if (prj != null && prj.isExternal() && prj.exists() && prj instanceof N4JSEclipseProject) {
            List list = validator.validate(resource, CheckMode.NORMAL_AND_FAST, cancelIndicator);
            this.markerManager.setIssues(uri, list);
        }
    }

    private CancelIndicator getCancelIndicator(IProgressMonitor monitor) {
        return () -> monitor.isCanceled();
    }

    private IResourceValidator getValidator(Resource resource) {
        return this.getService(resource, IResourceValidator.class);
    }

    private <T> T getService(Resource resource, Class<T> clazz) {
        IResourceServiceProvider serviceProvider = ((XtextResource)resource).getResourceServiceProvider();
        return (T)serviceProvider.get(clazz);
    }
}

