/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types.util;

import org.eclipse.n4js.ts.types.TMember;

public class NameStaticPair {
    public final String name;
    public final boolean isStatic;

    public static NameStaticPair of(TMember member) {
        return new NameStaticPair(member);
    }

    public NameStaticPair(TMember member) {
        this(member.getName(), member.isStatic());
    }

    public NameStaticPair(String name, boolean isStatic) {
        if (name == null) {
            throw new IllegalArgumentException("name may not be null");
        }
        this.name = name;
        this.isStatic = isStatic;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NameStaticPair) {
            NameStaticPair nsp = (NameStaticPair)obj;
            return nsp.isStatic == this.isStatic && nsp.name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return (this.isStatic ? 31 : 0) + this.name.hashCode();
    }

    public String toString() {
        if (this.isStatic) {
            return "static " + this.name;
        }
        return this.name;
    }
}

