/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem.constraints;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.util.Variance;

public class TypeConstraint {
    private static final String PREFIX = "\u27e8 ";
    private static final String SUFFIX = " \u27e9";
    public static final TypeConstraint TRUE = new TypeConstraint(null, null, Variance.CO);
    public static final TypeConstraint FALSE = new TypeConstraint(null, null, Variance.CONTRA);
    public final TypeArgument left;
    public final TypeArgument right;
    public final Variance variance;

    public TypeConstraint(TypeArgument left, TypeArgument right, Variance variance) {
        this.left = left;
        this.right = right;
        this.variance = variance;
    }

    public Type leftDeclaredType() {
        return this.left instanceof TypeRef ? ((TypeRef)this.left).getDeclaredType() : null;
    }

    public Type rightDeclaredType() {
        return this.right instanceof TypeRef ? ((TypeRef)this.right).getDeclaredType() : null;
    }

    public String toString() {
        if (this == FALSE) {
            return "\u27e8 FALSE \u27e9";
        }
        if (this == TRUE) {
            return "\u27e8 TRUE \u27e9";
        }
        return TypeConstraint.toString((EObject)this.left, (EObject)this.right, this.variance);
    }

    public static final String toString(EObject left, EObject right, Variance variance) {
        return PREFIX + TypeConstraint.toString(left) + " " + variance.getRelationString() + " " + TypeConstraint.toString(right) + SUFFIX;
    }

    private static final String toString(EObject obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof TypeArgument) {
            return ((TypeArgument)obj).getTypeRefAsString();
        }
        if (obj instanceof TFunction) {
            return ((TFunction)obj).getFunctionAsString();
        }
        if (obj instanceof TFormalParameter) {
            return ((TFormalParameter)obj).getFormalParameterAsString();
        }
        if (obj instanceof Type) {
            return ((Type)obj).getTypeAsString();
        }
        if (obj instanceof NamedElement) {
            return ((NamedElement)obj).getName();
        }
        if (obj instanceof IdentifiableElement) {
            return ((IdentifiableElement)obj).getName();
        }
        return obj.eClass().getName();
    }
}

