/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.dependencies;

import com.google.inject.Inject;
import javax.inject.Provider;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.n4js.ui.utils.AutobuildUtils;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.ui.wizard.dependencies.InstallOptions;
import org.eclipse.n4js.ui.wizard.dependencies.RunnableInstallDependencies;
import org.eclipse.n4js.ui.wizard.dependencies.SetupOptionsPage;
import org.eclipse.n4js.ui.wizard.dependencies.StartPage;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.swt.widgets.Shell;

public class ExternalLibrariesWizard
extends Wizard {
    private static final Logger LOGGER = Logger.getLogger(ExternalLibrariesWizard.class);
    @Inject
    private Provider<RunnableInstallDependencies> installDependenciesRunnable;
    @Inject
    private StatusHelper statusHelper;
    public static final String WINDOW_TITLE = "Setup External Libraries";
    private StartPage start;
    private SetupOptionsPage options;

    public ExternalLibrariesWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public String getWindowTitle() {
        return WINDOW_TITLE;
    }

    public void addPages() {
        this.start = new StartPage();
        this.options = new SetupOptionsPage();
        this.addPage((IWizardPage)this.start);
        this.addPage((IWizardPage)this.options);
    }

    public boolean performFinish() {
        try {
            InstallOptions installOptions = new InstallOptions();
            this.options.saveOptions(installOptions);
            RunnableInstallDependencies installDependnecies = (RunnableInstallDependencies)this.installDependenciesRunnable.get();
            installDependnecies.setInstallOptions(installOptions);
            this.getContainer().run(true, true, (IRunnableWithProgress)installDependnecies);
            IStatus resultStatus = installDependnecies.getResultStatus();
            if (!resultStatus.isOK()) {
                switch (resultStatus.getSeverity()) {
                    case 4: {
                        LOGGER.error((Object)resultStatus.toString());
                        this.showErrorMessage(resultStatus);
                        break;
                    }
                    case 8: {
                        LOGGER.info((Object)resultStatus.toString());
                        this.showWarnMessage();
                        break;
                    }
                    case 2: {
                        LOGGER.warn((Object)resultStatus.toString());
                        break;
                    }
                    case 1: {
                        LOGGER.info((Object)resultStatus.toString());
                        break;
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        LOGGER.debug((Object)("Unhandled status " + resultStatus.getSeverity()));
                        break;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            LOGGER.error((Object)"unhandled error while setting up dependencies", throwable);
            this.showErrorMessage(throwable);
        }
        return true;
    }

    public boolean performCancel() {
        return true;
    }

    private void showErrorMessage(Throwable throwable) {
        IStatus status = this.statusHelper.createError(throwable);
        this.showErrorMessage(status);
    }

    private void showErrorMessage(IStatus status) {
        UIUtils.getDisplay().asyncExec(() -> {
            String title = "Setting up external libraries failed.";
            String message = "Error while setting up external libraries.\n";
            message = String.valueOf(message) + "Please check your Error Log view for the detailed log about the failure.\n";
            message = String.valueOf(message) + " (note that autobuild is " + (AutobuildUtils.get() ? "on" : "off") + ")";
            ErrorDialog.openError((Shell)UIUtils.getShell(), (String)title, (String)message, (IStatus)status);
        });
    }

    private void showWarnMessage() {
        UIUtils.getDisplay().asyncExec(() -> {
            String title = "Setting up external was cancelled.";
            String message = "Due to cancellation not all libraries were installed.\n";
            message = String.valueOf(message) + " (note that autobuild is " + (AutobuildUtils.get() ? "on" : "off") + ")";
            MessageDialog.openWarning((Shell)UIUtils.getShell(), (String)title, (String)message);
        });
    }
}

