/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class OpenManifestHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection;
        IEditorInput input;
        IProject proj;
        HashSet<IProject> projects = new HashSet<IProject>();
        if (HandlerUtil.getActivePart((ExecutionEvent)event) instanceof IEditorPart && (proj = this.getProject(input = ((IEditorPart)HandlerUtil.getActivePart((ExecutionEvent)event)).getEditorInput())) != null && WorkspaceModelManager.isPluginProject((IProject)proj)) {
            projects.add(proj);
        }
        if ((selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event)) instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            for (Object element : ssel) {
                IProject proj2 = null;
                if (element instanceof IFile) {
                    proj2 = ((IFile)element).getProject();
                }
                if (proj2 == null && element instanceof IProject) {
                    proj2 = (IProject)element;
                }
                if (proj2 == null && element instanceof IAdaptable) {
                    Object o;
                    IWorkbenchAdapter workbenchAdapter;
                    IResource resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
                    if (resource != null) {
                        proj2 = resource.getProject();
                    }
                    if (proj2 == null && (workbenchAdapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null && (o = workbenchAdapter.getParent(element)) instanceof IAdaptable && (resource = (IResource)((IAdaptable)o).getAdapter(IResource.class)) != null) {
                        proj2 = resource.getProject();
                    }
                }
                if (proj2 == null || !WorkspaceModelManager.isPluginProject((IProject)proj2)) continue;
                projects.add(proj2);
            }
        }
        if (projects.size() > 0) {
            BusyIndicator.showWhile((Display)PDEPlugin.getActiveWorkbenchShell().getDisplay(), () -> {
                for (IProject project : projects) {
                    IFile file = PDEProject.getManifest((IProject)project);
                    if (file == null || !file.exists()) {
                        file = PDEProject.getPluginXml((IProject)project);
                    }
                    if (file == null || !file.exists()) {
                        file = PDEProject.getFragmentXml((IProject)project);
                    }
                    if (file == null || !file.exists()) {
                        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.OpenManifestsAction_title, (String)NLS.bind((String)PDEUIMessages.OpenManifestsAction_cannotFind, (Object)project.getName()));
                        continue;
                    }
                    try {
                        IDE.openEditor((IWorkbenchPage)PDEPlugin.getActivePage(), (IFile)file, (String)"org.eclipse.pde.ui.manifestEditor");
                    }
                    catch (PartInitException partInitException) {
                        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.OpenManifestsAction_title, (String)NLS.bind((String)PDEUIMessages.OpenManifestsAction_cannotOpen, (Object)project.getName()));
                    }
                }
            });
        } else {
            MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.OpenManifestsAction_title, (String)PDEUIMessages.OpenManifestAction_noManifest);
        }
        return null;
    }

    private IProject getProject(IEditorInput input) {
        IAdapterManager adapterManager = Platform.getAdapterManager();
        Object o = input.getAdapter(IResource.class);
        if (o != null || (o = adapterManager.getAdapter((Object)input, IResource.class)) != null) {
            return ((IFile)o).getProject();
        }
        o = input.getAdapter(IProject.class);
        if (o != null || (o = adapterManager.getAdapter((Object)input, IProject.class)) != null) {
            return (IProject)o;
        }
        return null;
    }
}

