/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesbuilder;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.PropertyNameOwner;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesbuilder.N4JSTypesBuilderHelper;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;

class N4JSFieldTypesBuilder {
    @Inject
    @Extension
    private N4JSTypesBuilderHelper _n4JSTypesBuilderHelper;

    N4JSFieldTypesBuilder() {
    }

    boolean relinkField(N4FieldDeclaration n4Field, TClassifier classifierType, boolean preLinkingPhase, int idx) {
        if (n4Field.getName() == null && !n4Field.hasComputedPropertyName()) {
            return false;
        }
        TMember _get = (TMember)classifierType.getOwnedMembers().get(idx);
        TField field = (TField)_get;
        this._n4JSTypesBuilderHelper.ensureEqualName((NamedElement)n4Field, (IdentifiableElement)field);
        field.setAstElement((EObject)n4Field);
        n4Field.setDefinedField(field);
        return true;
    }

    TField createField(N4FieldDeclaration n4Field, TClassifier classifierType, boolean preLinkingPhase) {
        if (n4Field.getName() == null && !n4Field.hasComputedPropertyName()) {
            return null;
        }
        TField field = TypesFactory.eINSTANCE.createTField();
        this._n4JSTypesBuilderHelper.setMemberName((TMember)field, (PropertyNameOwner)n4Field);
        field.setConst(n4Field.isConst());
        field.setDeclaredStatic(n4Field.isDeclaredStatic());
        field.setDeclaredFinal(n4Field.isDeclaredFinal());
        field.setOptional(n4Field.isDeclaredOptional());
        field.setDeclaredOverride(AnnotationDefinition.OVERRIDE.hasAnnotation((AnnotableElement)n4Field));
        boolean providesInitializer = AnnotationDefinition.PROVIDES_INITIALZER.hasAnnotation((AnnotableElement)n4Field);
        field.setHasExpression(n4Field.getExpression() != null || providesInitializer);
        this._n4JSTypesBuilderHelper.copyAnnotations((TAnnotableElement)field, (AnnotableElement)n4Field, preLinkingPhase);
        this.setMemberAccessModifier(field, n4Field);
        this.setFieldType(field, n4Field, preLinkingPhase);
        field.setAstElement((EObject)n4Field);
        n4Field.setDefinedField(field);
        return field;
    }

    private void setFieldType(TField field, N4FieldDeclaration n4Field, boolean preLinkingPhase) {
        if (!preLinkingPhase) {
            boolean _tripleNotEquals;
            TypeRef _declaredTypeRef = n4Field.getDeclaredTypeRef();
            boolean bl = _tripleNotEquals = _declaredTypeRef != null;
            if (_tripleNotEquals) {
                field.setTypeRef((TypeRef)TypeUtils.copyWithProxies((EObject)n4Field.getDeclaredTypeRef()));
            } else {
                field.setTypeRef((TypeRef)TypeUtils.createDeferredTypeRef());
            }
        }
    }

    private void setMemberAccessModifier(TField fieldType, N4FieldDeclaration n4Field) {
        Procedures.Procedure1 _function = modifier -> fieldType.setDeclaredMemberAccessModifier(modifier);
        this._n4JSTypesBuilderHelper.setMemberAccessModifier((Procedures.Procedure1<? super MemberAccessModifier>)_function, (Collection<? extends N4Modifier>)n4Field.getDeclaredModifiers(), (List<Annotation>)n4Field.getAnnotations());
    }
}

