/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.adoc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.jsdoc2spec.CopyrightHeader;
import org.eclipse.n4js.jsdoc2spec.SpecFile;
import org.eclipse.n4js.jsdoc2spec.adoc.SourceEntry;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecIdentifiableElementSection;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecSection;
import org.eclipse.n4js.jsdoc2spec.adoc.StringCountUtils;
import org.eclipse.n4js.ts.types.FieldAccessor;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TN4Classifier;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.Type;

public class SpecModuleFile
extends SpecFile {
    private final MemberComparator memberComparator = new MemberComparator();
    private final TypeComparator typeComparator = new TypeComparator();
    private final List<SpecIdentifiableElementSection> allSections = new ArrayList<SpecIdentifiableElementSection>();
    private final SortedSet<SpecIdentifiableElementSection> variables = new TreeSet<SpecIdentifiableElementSection>();
    private final SortedSet<SpecIdentifiableElementSection> functions = new TreeSet<SpecIdentifiableElementSection>();
    private final SortedSet<Type> types = new TreeSet<Type>(this.typeComparator);
    private final Map<Type, SortedSet<SpecIdentifiableElementSection>> typeElementsOfType = new TreeMap<Type, SortedSet<SpecIdentifiableElementSection>>(this.typeComparator);
    private final Map<SpecIdentifiableElementSection, Integer> startlineOfElem = new HashMap<SpecIdentifiableElementSection, Integer>();
    private String newContent;

    public static int getHeaderLength() {
        String dummyHeader = SpecModuleFile.generateModuleHeader("", "");
        return StringCountUtils.countNewLines(dummyHeader);
    }

    public SpecModuleFile(File file) {
        super(file);
    }

    @Override
    public String getPackageDisplayName() {
        SpecIdentifiableElementSection src = this.allSections.get(0);
        String packageName = src.getSourceEntry().packageName;
        return packageName;
    }

    public String getModuleName() {
        SpecIdentifiableElementSection src = this.allSections.get(0);
        String moduleName = src.getSourceEntry().module;
        return moduleName;
    }

    @Override
    public void add(SpecSection specElem) {
        if (!(specElem instanceof SpecIdentifiableElementSection)) {
            return;
        }
        SpecIdentifiableElementSection specIE = (SpecIdentifiableElementSection)specElem;
        EObject container = specIE.idElement.eContainer();
        if (container instanceof Type) {
            this.addTypeElement((Type)container, specIE);
            return;
        }
        if (specIE.idElement instanceof TFunction) {
            this.functions.add(specIE);
            this.allSections.add(specIE);
            return;
        }
        if (specIE.idElement instanceof TVariable) {
            this.variables.add(specIE);
            this.allSections.add(specIE);
            return;
        }
        if (specIE.idElement instanceof Type) {
            this.addTypeElement((Type)specIE.idElement, specIE);
            return;
        }
        throw new RuntimeException("Missing Implementation");
    }

    private void addTypeElement(Type type, SpecIdentifiableElementSection specIE) {
        boolean addToList;
        SortedSet<SpecIdentifiableElementSection> containerElements;
        this.types.add(type);
        if (!this.typeElementsOfType.containsKey(type)) {
            containerElements = new TreeSet<SpecIdentifiableElementSection>(this.memberComparator);
            this.typeElementsOfType.put(type, containerElements);
        }
        boolean bl = addToList = !(containerElements = this.typeElementsOfType.get(type)).contains(specIE);
        if (specIE.idElement.eContainer() instanceof TClass) {
            TClass tClass = (TClass)specIE.idElement.eContainer();
            addToList |= tClass.isStaticPolyfill();
        }
        if (addToList) {
            containerElements.add(specIE);
            this.allSections.add(specIE);
        }
    }

    public Collection<SpecIdentifiableElementSection> getSpecSections() {
        return this.allSections;
    }

    @Override
    public String getNewContent() {
        this.ensureNewContent();
        return this.newContent;
    }

    @Override
    public int getOffsetStart(SpecSection entry) {
        this.ensureNewContent();
        if (!this.startlineOfElem.containsKey(entry)) {
            throw new RuntimeException("Entry not in change set.");
        }
        int startOffset = this.startlineOfElem.get(entry);
        return startOffset;
    }

    @Override
    public int getOffsetEnd(SpecSection entry) {
        this.ensureNewContent();
        if (!this.startlineOfElem.containsKey(entry)) {
            throw new RuntimeException("Entry not in change set.");
        }
        return this.getOffsetStart(entry) + entry.getGeneratedLineCount() - 1;
    }

    private String ensureNewContent() {
        if (this.newContent != null) {
            return this.newContent;
        }
        StringBuilder strb = new StringBuilder();
        int startline = 1;
        startline = this.generateModuleHeader(strb, startline);
        startline = this.generateVariableSection(strb, startline);
        startline = this.generateFunctionSection(strb, startline);
        for (Type type : this.types) {
            startline = this.generateTypeSection(strb, startline, type);
        }
        this.newContent = strb.toString();
        return this.newContent;
    }

    private int generateModuleHeader(StringBuilder strb, int startline) {
        if (this.variables.isEmpty() && this.functions.isEmpty() && this.types.isEmpty()) {
            return startline;
        }
        String title = this.getModuleName().replaceAll("/", ".");
        String header = SpecModuleFile.generateModuleHeader(title, this.getBaseDir());
        strb.append(header);
        int nextStartline = startline + StringCountUtils.countNewLines(header);
        return nextStartline;
    }

    private static String generateModuleHeader(String title, String basedir) {
        String header = CopyrightHeader.getAdoc();
        header = String.valueOf(header) + "include::{find}config.adoc[]\n";
        header = String.valueOf(header) + ":docinfodir: " + basedir + "headers/apiModules\n";
        header = String.valueOf(header) + ":linkattrs:\n";
        header = String.valueOf(header) + ":toc:\n\n";
        header = String.valueOf(header) + "= Module ";
        header = String.valueOf(header) + title;
        header = String.valueOf(header) + "\n\n";
        return header;
    }

    private int generateVariableSection(StringBuilder strb, int startline) {
        if (this.variables.isEmpty()) {
            return startline;
        }
        strb.append("== Variables\n\n");
        startline += 2;
        startline = this.generateSubElements(strb, startline, this.variables);
        return startline;
    }

    private int generateFunctionSection(StringBuilder strb, int startline) {
        if (this.functions.isEmpty()) {
            return startline;
        }
        strb.append("== Functions\n\n");
        startline += 2;
        startline = this.generateSubElements(strb, startline, this.functions);
        return startline;
    }

    private int generateTypeSection(StringBuilder strb, int startline, Type type) {
        if (this.typeElementsOfType.get(type).isEmpty()) {
            return startline;
        }
        startline = this.generateTypeHeader(strb, startline, type);
        SortedSet<SpecIdentifiableElementSection> typeElements = this.typeElementsOfType.get(type);
        startline = this.generateSubElements(strb, startline, typeElements);
        return startline;
    }

    private int generateSubElements(StringBuilder strb, int startline, SortedSet<SpecIdentifiableElementSection> elems) {
        for (SpecIdentifiableElementSection property : elems) {
            String generatedAdoc = property.getGeneratedADocText();
            strb.append(generatedAdoc);
            this.startlineOfElem.put(property, startline);
            startline += StringCountUtils.countNewLines(generatedAdoc);
        }
        return startline;
    }

    private int generateTypeHeader(StringBuilder strb, int startline, Type type) {
        strb.append("== ");
        if (type instanceof TClass) {
            strb.append("Class ");
        }
        if (type instanceof TInterface) {
            strb.append("Interface ");
        }
        if (type instanceof TEnum) {
            strb.append("Enum ");
        }
        strb.append(type.getName());
        strb.append("\n\n");
        return startline + 2;
    }

    private String getBaseDir() {
        SpecIdentifiableElementSection src = this.allSections.get(0);
        int upLinkDepth = src.getSourceEntry().adocPathElems.length;
        String basedir = "../";
        int i = 0;
        while (i < upLinkDepth) {
            basedir = String.valueOf(basedir) + "../";
            ++i;
        }
        return basedir;
    }

    private static class MemberComparator
    implements Comparator<SpecIdentifiableElementSection> {
        private MemberComparator() {
        }

        @Override
        public int compare(SpecIdentifiableElementSection m1, SpecIdentifiableElementSection m2) {
            String name1 = this.getCompareName(m1);
            String name2 = this.getCompareName(m2);
            return name1.compareTo(name2);
        }

        private String getCompareName(SpecIdentifiableElementSection m) {
            SourceEntry sourceEntry = m.getSourceEntry();
            String name = "Z ";
            if (m.idElement instanceof TN4Classifier || m.idElement instanceof TEnum) {
                name = "A ";
            }
            if (m.idElement instanceof TField) {
                name = "C ";
            }
            if (m.idElement instanceof FieldAccessor) {
                name = "D ";
            }
            if (m.idElement instanceof TMethod) {
                name = "E ";
            }
            if (sourceEntry.property.equals("constructor")) {
                name = "B ";
            }
            name = String.valueOf(name) + sourceEntry.element;
            name = String.valueOf(name) + sourceEntry.delimiter;
            name = String.valueOf(name) + sourceEntry.property;
            return name;
        }
    }

    private static class TypeComparator
    implements Comparator<Type> {
        private TypeComparator() {
        }

        @Override
        public int compare(Type t1, Type t2) {
            String name1 = this.getCompareName(t1);
            String name2 = this.getCompareName(t2);
            return name1.compareTo(name2);
        }

        private String getCompareName(Type t1) {
            String name = "Z ";
            if (t1 instanceof TInterface) {
                name = "A ";
            }
            if (t1 instanceof TEnum) {
                name = "B ";
            }
            if (t1 instanceof TClass) {
                name = "C ";
            }
            name = String.valueOf(name) + t1.getName();
            return name;
        }
    }
}

