/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.n4js.transpiler.es.assistants.BootstrapCallAssistant;
import org.eclipse.n4js.transpiler.utils.TranspilerUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class EnumDeclarationTransformation
extends Transformation {
    @Inject
    private BootstrapCallAssistant bootstrapCallAssistant;
    @Inject
    private TypeAssistant typeAssistant;

    public void assertPreConditions() {
        Functions.Function1 _function = it -> {
            boolean _isTopLevel = this.typeAssistant.isTopLevel((TypeDefiningElement)it);
            return !_isTopLevel;
        };
        this.assertFalse("only top-level enums are supported, for now", IteratorExtensions.exists((Iterator)Iterators.filter((Iterator)this.getState().im.eAllContents(), N4EnumDeclaration.class), (Functions.Function1)_function));
    }

    public void assertPostConditions() {
        Functions.Function1 _function = it -> it instanceof N4EnumDeclaration;
        this.assertFalse("there should not be any N4EnumDeclarations in the intermediate model", IteratorExtensions.exists((Iterator)this.getState().im.eAllContents(), (Functions.Function1)_function));
    }

    public void analyze() {
    }

    public void transform() {
        Consumer<N4EnumDeclaration> _function = it -> this.transformEnumDecl((N4EnumDeclaration)it);
        this.collectNodes((EObject)this.getState().im, N4EnumDeclaration.class, false).forEach(_function);
    }

    private void transformEnumDecl(N4EnumDeclaration enumDecl) {
        boolean _isStringBased = this.isStringBased(enumDecl);
        if (_isStringBased) {
            this.remove((EObject)enumDecl);
        } else {
            VariableDeclaration varDecl = this.createVarDecl(enumDecl);
            ExpressionStatement makeEnumCall = this.bootstrapCallAssistant.createMakeEnumCall(enumDecl);
            this.getState().tracer.copyTrace((EObject)enumDecl, new EObject[]{makeEnumCall});
            this.replace(enumDecl, varDecl);
            EObject root = TranspilerUtils.orContainingExportDeclaration((EObject)varDecl.eContainer());
            this.insertAfter(root, new EObject[]{makeEnumCall});
            this.getState().info.markAsToHoist(varDecl);
        }
    }

    private VariableDeclaration createVarDecl(N4EnumDeclaration enumDecl) {
        VariableDeclaration __VariableDeclaration = TranspilerBuilderBlocks._VariableDeclaration((String)enumDecl.getName());
        Procedures.Procedure1 _function = it -> {
            FormalParameter __Fpar = TranspilerBuilderBlocks._Fpar((String)"name");
            FormalParameter __Fpar_1 = TranspilerBuilderBlocks._Fpar((String)"value");
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("this.name = name;");
            _builder.newLine();
            _builder.append("this.value = value;");
            _builder.newLine();
            it.setExpression((Expression)TranspilerBuilderBlocks._FunExpr((boolean)false, (String)enumDecl.getName(), (FormalParameter[])new FormalParameter[]{__Fpar, __Fpar_1}, (Statement[])new Statement[]{TranspilerBuilderBlocks._SnippetAsStmnt((String)_builder.toString())}));
        };
        return (VariableDeclaration)ObjectExtensions.operator_doubleArrow((Object)__VariableDeclaration, (Procedures.Procedure1)_function);
    }

    private boolean isStringBased(N4EnumDeclaration enumDecl) {
        return AnnotationDefinition.STRING_BASED.hasAnnotation((AnnotableElement)enumDecl);
    }
}

