/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.n4js.ui.editor.N4JSDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.hyperlinking.DefaultHyperlinkDetector;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkHelper;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class N4JSHyperlinkDetector
extends DefaultHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(final ITextViewer textViewer, final IRegion region, final boolean canShowMultipleHyperlinks) {
        IDocument xtextDocument = textViewer.getDocument();
        if (!(xtextDocument instanceof N4JSDocument)) {
            return super.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks);
        }
        final IHyperlinkHelper helper = this.getHelper();
        return ((N4JSDocument)xtextDocument).tryReadOnly(new IUnitOfWork<IHyperlink[], XtextResource>(){

            public IHyperlink[] exec(XtextResource resource) throws Exception {
                if (resource == null) {
                    return null;
                }
                if (helper instanceof ISourceViewerAware && textViewer instanceof ISourceViewer) {
                    ((ISourceViewerAware)helper).setSourceViewer((ISourceViewer)textViewer);
                }
                return helper.createHyperlinksByOffset(resource, region.getOffset(), canShowMultipleHyperlinks);
            }
        }, null);
    }
}

