/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.wst.sse.ui.typing.AbstractCharacterPairInserter;

public class CSSCharacterPairInserter
extends AbstractCharacterPairInserter {
    public boolean hasPair(char c) {
        switch (c) {
            case '\"': 
            case '\'': 
            case '(': 
            case '[': 
            case '{': {
                return true;
            }
        }
        return false;
    }

    protected char getPair(char c) {
        switch (c) {
            case '\"': 
            case '\'': {
                return c;
            }
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '{': {
                return '}';
            }
        }
        throw new IllegalArgumentException();
    }

    protected LinkedModeUI.IExitPolicy getExitPolicy(char exit, char escape, IDocument document) {
        return new ExitPolicy(exit, escape, document);
    }

    class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private char fExit;
        private char fEscape;
        private IDocument fDocument;

        public ExitPolicy(char exit, char escape, IDocument document) {
            this.fExit = exit;
            this.fEscape = escape;
            this.fDocument = document;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (!this.isMasked(offset)) {
                if (event.character == this.fExit) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
                if (event.character == '\r' || event.character == '\n' && offset > 0) {
                    try {
                        if (this.fDocument.getChar(offset - 1) == '{') {
                            return new LinkedModeUI.ExitFlags(1, true);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            try {
                return this.fEscape == this.fDocument.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }
}

