/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.views.markers.CachedMarkerBuilder;
import org.eclipse.ui.internal.views.markers.MarkerCategory;
import org.eclipse.ui.internal.views.markers.MarkerComparator;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerSortUtil;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerGroupingEntry;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

class Markers {
    static final MarkerCategory[] EMPTY_CATEGORY_ARRAY = new MarkerCategory[0];
    static final MarkerEntry[] EMPTY_ENTRY_ARRAY = new MarkerEntry[0];
    private volatile MarkerEntry[] markerEntryArray = EMPTY_ENTRY_ARRAY;
    private volatile MarkerCategory[] categories = EMPTY_CATEGORY_ARRAY;
    private CachedMarkerBuilder builder;
    private volatile boolean inChange;
    private Map<IMarker, MarkerEntry> markerToEntryMap;
    private Integer[] markerCounts;

    Markers(CachedMarkerBuilder builder) {
        this.builder = builder;
    }

    synchronized boolean updateWithNewMarkers(Collection<MarkerEntry> markerEntries, boolean sortAndGroup, IProgressMonitor monitor) {
        boolean initialVal = this.inChange;
        try {
            this.inChange = true;
            if (this.markerToEntryMap != null) {
                this.markerToEntryMap.clear();
                this.markerToEntryMap = null;
            }
            this.markerCounts = null;
            if (markerEntries.isEmpty()) {
                this.categories = EMPTY_CATEGORY_ARRAY;
                this.markerEntryArray = EMPTY_ENTRY_ARRAY;
                return true;
            }
            if (monitor.isCanceled()) {
                return false;
            }
            MarkerEntry[] markerArray = new MarkerEntry[markerEntries.size()];
            markerEntries.toArray(markerArray);
            this.markerEntryArray = markerArray;
            if (sortAndGroup) {
                if (monitor.isCanceled()) {
                    return false;
                }
                this.sortAndMakeCategories(monitor);
                if (monitor.isCanceled()) {
                    return false;
                }
            } else {
                this.categories = EMPTY_CATEGORY_ARRAY;
            }
            return true;
        }
        finally {
            this.inChange = initialVal;
        }
    }

    private synchronized boolean sortAndMakeCategories(IProgressMonitor monitor) {
        boolean initialVal = this.inChange;
        try {
            this.inChange = true;
            if (this.builder.isShowingHierarchy()) {
                MarkerCategory[] markerCategories = this.groupIntoCategories(monitor, this.markerEntryArray);
                this.categories = markerCategories;
            } else {
                this.categories = EMPTY_CATEGORY_ARRAY;
            }
            if (monitor.isCanceled()) {
                return false;
            }
            monitor.subTask(MarkerMessages.MarkerView_processUpdates);
            boolean bl = this.sortMarkerEntries(monitor);
            return bl;
        }
        finally {
            this.inChange = initialVal;
        }
    }

    synchronized boolean sortMarkerEntries(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        boolean initialVal = this.inChange;
        MarkerComparator markerComparator = this.builder.getComparator();
        MarkerCategory lastCategory = null;
        try {
            this.inChange = true;
            if (this.builder.isShowingHierarchy()) {
                Comparator<MarkerItem> comparator = markerComparator.getFieldsComparator();
                MarkerCategory[] markerCategoryArray = this.categories;
                int n = this.categories.length;
                int n2 = 0;
                while (n2 < n) {
                    MarkerCategory category = markerCategoryArray[n2];
                    if (monitor.isCanceled()) {
                        return false;
                    }
                    lastCategory = category;
                    category.resetChildren();
                    int avaliable = category.end - category.start + 1;
                    int effLimit = this.getShowingLimit(avaliable);
                    MarkerSortUtil.sortStartingKElement(this.markerEntryArray, comparator, category.start, category.end, effLimit, monitor);
                    ++n2;
                }
            } else {
                if (monitor.isCanceled()) {
                    return false;
                }
                int avaialble = this.markerEntryArray.length - 1;
                int effLimit = this.getShowingLimit(avaialble);
                MarkerSortUtil.sortStartingKElement(this.markerEntryArray, markerComparator, effLimit, monitor);
            }
            if (monitor.isCanceled()) {
                return false;
            }
            monitor.worked(50);
            return true;
        }
        catch (IllegalArgumentException e) {
            StringBuilder err = new StringBuilder("Bug 371586: broken comparator. ");
            if (lastCategory != null) {
                err.append(lastCategory);
            } else {
                err.append(markerComparator.getCategory());
            }
            err.append(", fields: ");
            err.append(Arrays.toString(markerComparator.getFields()));
            IDEWorkbenchPlugin.log(err.toString(), e);
            return false;
        }
        finally {
            this.inChange = initialVal;
        }
    }

    private int getShowingLimit(int available) {
        boolean limitsEnabled = this.builder.getGenerator().isMarkerLimitsEnabled();
        if (!limitsEnabled) {
            return available;
        }
        int limit = this.builder.getGenerator().getMarkerLimits();
        int effLimit = limit;
        if (available < effLimit || limit <= 0) {
            effLimit = available;
        }
        return effLimit;
    }

    private MarkerCategory[] groupIntoCategories(IProgressMonitor monitor, MarkerEntry[] newMarkers) {
        Map<MarkerGroupingEntry, Integer> boundaryInfoMap = this.groupMarkerEntries(newMarkers, this.builder.getCategoryGroup(), newMarkers.length - 1, monitor);
        int start = 0;
        MarkerCategory[] markerCategories = new MarkerCategory[boundaryInfoMap.size()];
        int i = 0;
        int end = 0;
        for (Map.Entry<MarkerGroupingEntry, Integer> entry : boundaryInfoMap.entrySet()) {
            end = entry.getValue();
            markerCategories[i++] = new MarkerCategory(this, start, end, this.builder.getCategoryGroup().getMarkerField().getValue(newMarkers[start]));
            start = end + 1;
        }
        return markerCategories;
    }

    private Map<MarkerGroupingEntry, Integer> groupMarkerEntries(MarkerEntry[] entries, MarkerGroup group, int k, IProgressMonitor monitor) {
        TreeMap<MarkerGroupingEntry, ArrayList<MarkerEntry>> map = new TreeMap<MarkerGroupingEntry, ArrayList<MarkerEntry>>(group.getEntriesComparator());
        int i = 0;
        while (i <= k) {
            IMarker marker = entries[i].getMarker();
            if (marker != null) {
                if (monitor.isCanceled()) {
                    return Collections.emptyMap();
                }
                try {
                    MarkerGroupingEntry groupingEntry = group.findGroupValue(marker.getType(), marker);
                    ArrayList<MarkerEntry> list = (ArrayList<MarkerEntry>)map.get(groupingEntry);
                    if (list == null) {
                        list = new ArrayList<MarkerEntry>();
                        map.put(groupingEntry, list);
                    }
                    list.add(entries[i]);
                }
                catch (CoreException coreException) {
                    entries[i].checkIfMarkerStale();
                }
            }
            ++i;
        }
        TreeMap<MarkerGroupingEntry, Integer> result = new TreeMap<MarkerGroupingEntry, Integer>(group.getEntriesComparator());
        int i2 = 0;
        for (Map.Entry mapEntry : map.entrySet()) {
            if (monitor.isCanceled()) {
                return Collections.emptyMap();
            }
            MarkerGroupingEntry key = mapEntry.getKey();
            for (MarkerEntry entry : (List)mapEntry.getValue()) {
                entries[i2++] = entry;
            }
            result.put(key, i2 - 1);
        }
        return result;
    }

    Integer[] getMarkerCounts() {
        if (this.markerCounts == null) {
            this.markerCounts = Markers.getMarkerCounts(this.markerEntryArray);
        }
        return this.markerCounts;
    }

    static Integer[] getMarkerCounts(MarkerEntry[] entries) {
        int[] ints = new int[4];
        MarkerEntry[] markerEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerEntry entry = markerEntryArray[n2];
            IMarker marker = entry.getMarker();
            int severity = -1;
            Object value = null;
            try {
                value = marker.getAttribute("severity");
            }
            catch (CoreException coreException) {
                entry.checkIfMarkerStale();
            }
            if (value instanceof Integer) {
                severity = (Integer)value;
            }
            if (severity >= 0) {
                int n3 = severity;
                ints[n3] = ints[n3] + 1;
            } else {
                ints[3] = ints[3] + 1;
            }
            ++n2;
        }
        return new Integer[]{ints[2], ints[1], ints[0], ints[3]};
    }

    public synchronized MarkerItem getMarkerItem(IMarker marker) {
        if (this.markerToEntryMap == null) {
            this.markerToEntryMap = new HashMap<IMarker, MarkerEntry>();
            MarkerEntry[] markerEntryArray = this.markerEntryArray;
            int n = this.markerEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                MarkerEntry markerEntry = markerEntryArray[n2];
                IMarker nextMarker = markerEntry.getMarker();
                if (nextMarker != null) {
                    this.markerToEntryMap.put(nextMarker, markerEntry);
                }
                ++n2;
            }
        }
        return this.markerToEntryMap.get(marker);
    }

    MarkerEntry[] getMarkerEntryArray() {
        return this.markerEntryArray;
    }

    MarkerCategory[] getCategories() {
        return this.categories;
    }

    public MarkerSupportItem[] getElements() {
        if (this.builder.isShowingHierarchy()) {
            return this.categories;
        }
        return this.markerEntryArray;
    }

    CachedMarkerBuilder getBuilder() {
        return this.builder;
    }

    Markers getClone() {
        Markers markers = new Markers(this.builder);
        if (!this.inChange) {
            markers.markerEntryArray = (MarkerEntry[])this.markerEntryArray.clone();
            markers.categories = (MarkerCategory[])this.categories.clone();
        }
        return markers;
    }

    boolean isInChange() {
        return this.inChange;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.builder == null ? 0 : this.builder.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Markers)) {
            return false;
        }
        Markers other = (Markers)obj;
        return !(this.builder == null ? other.builder != null : !this.builder.equals(other.builder));
    }
}

