/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.n4js.ui.workingsets.Resetable;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerBroker;
import org.eclipse.n4js.utils.Diff;
import org.eclipse.n4js.utils.StatusHelper;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class WorkingSetManagerImpl
implements WorkingSetManager,
Resetable {
    private static final Logger LOGGER = Logger.getLogger(WorkingSetManagerImpl.class);
    protected static final String SEPARATOR = "#";
    protected static final String EMPTY_STRING = "";
    private static final String ORDERED_IDS_KEY = ".orderedIds";
    private static final String VISIBLE_IDS_KEY = ".visibleIds";
    private List<WorkingSet> allWorkingSets = null;
    private List<WorkingSet> visibleWorkingSets = null;
    protected final List<String> orderedWorkingSetIds = Lists.newArrayList();
    protected final Collection<String> visibleWorkingSetIds = Sets.newHashSet();
    @Inject
    protected StatusHelper statusHelper;
    @Inject
    private WorkingSetManagerBroker workingSetManagerBroker;

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public WorkingSetManagerBroker getWorkingSetManagerBroker() {
        return this.workingSetManagerBroker;
    }

    @Override
    public WorkingSet[] getWorkingSets() {
        return (WorkingSet[])Iterables.toArray(this.getOrCreateVisibleWorkingSets(), WorkingSet.class);
    }

    @Override
    public WorkingSet[] getAllWorkingSets() {
        return (WorkingSet[])Iterables.toArray(this.getOrCreateAllWorkingSets(), WorkingSet.class);
    }

    @Override
    public void select(Iterable<WorkingSet> workingSets) {
        this.visibleWorkingSetIds.addAll((Collection<String>)FluentIterable.from(workingSets).transform(ws -> ws.getId()).toList());
    }

    @Override
    public void unselect(Iterable<WorkingSet> workingSets) {
        this.visibleWorkingSetIds.removeAll((Collection<?>)FluentIterable.from(workingSets).transform(ws -> ws.getId()).toList());
    }

    @Override
    public IStatus saveState(IProgressMonitor monitor) {
        Preferences node = this.getPreferences();
        node.put(ORDERED_IDS_KEY, Joiner.on((String)SEPARATOR).join(this.orderedWorkingSetIds));
        node.put(VISIBLE_IDS_KEY, Joiner.on((String)SEPARATOR).join(this.visibleWorkingSetIds));
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            String message = "Error occurred while saving state to preference store.";
            LOGGER.error((Object)"Error occurred while saving state to preference store.", (Throwable)e);
            return this.statusHelper.createError("Error occurred while saving state to preference store.", (Throwable)e);
        }
        return this.statusHelper.OK();
    }

    @Override
    public IStatus restoreState(IProgressMonitor monitor) {
        String visibleLabels;
        Preferences node = this.getPreferences();
        String orderedLabels = node.get(ORDERED_IDS_KEY, EMPTY_STRING);
        if (!Strings.isNullOrEmpty((String)orderedLabels)) {
            this.orderedWorkingSetIds.clear();
            this.orderedWorkingSetIds.addAll(Arrays.asList(orderedLabels.split(SEPARATOR)));
        }
        if (!Strings.isNullOrEmpty((String)(visibleLabels = node.get(VISIBLE_IDS_KEY, EMPTY_STRING)))) {
            this.visibleWorkingSetIds.clear();
            this.visibleWorkingSetIds.addAll(Arrays.asList(visibleLabels.split(SEPARATOR)));
        }
        this.discardWorkingSetCaches();
        return this.statusHelper.OK();
    }

    @Override
    public void updateState(Diff<WorkingSet> diff) {
        if (!diff.isEmpty()) {
            this.visibleWorkingSetIds.clear();
            this.select(Arrays.asList((WorkingSet[])diff.getNewItems()));
            this.orderedWorkingSetIds.clear();
            WorkingSet[] workingSetArray = (WorkingSet[])diff.getNewAllItems();
            int n = workingSetArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorkingSet workingSet = workingSetArray[n2];
                this.orderedWorkingSetIds.add(workingSet.getId());
                ++n2;
            }
            this.discardWorkingSetCaches();
            this.getWorkingSetManagerBroker().fireWorkingSetManagerUpdated(this.getId(), diff);
        }
    }

    @Override
    public int compare(WorkingSet left, WorkingSet right) {
        if (left == null) {
            return right == null ? 0 : 1;
        }
        String rightId = right.getId();
        String leftId = left.getId();
        Preconditions.checkNotNull((Object)leftId, (Object)("The ID of the working set must not be null. Working set: " + left));
        Preconditions.checkNotNull((Object)rightId, (Object)("The ID of the working set must not be null. Working set: " + right));
        if (this.orderedWorkingSetIds.isEmpty()) {
            if ("Other Projects".equals(leftId)) {
                return "Other Projects".equals(rightId) ? 0 : -1;
            }
            if ("Other Projects".equals(rightId)) {
                return "Other Projects".equals(leftId) ? 0 : 1;
            }
            String rightName = right.getName();
            String leftName = left.getName();
            Preconditions.checkNotNull((Object)leftName, (Object)("The name of the working set must not be null. Working set: " + left));
            Preconditions.checkNotNull((Object)rightName, (Object)("The name of the working set must not be null. Working set: " + right));
            return leftName.compareTo(rightName);
        }
        return this.orderedWorkingSetIds.indexOf(leftId) - this.orderedWorkingSetIds.indexOf(rightId);
    }

    @Override
    public void reset() {
        try {
            this.getPreferences().clear();
            this.getPreferences().flush();
            this.discardWorkingSetState();
            this.discardWorkingSetCaches();
            this.restoreState((IProgressMonitor)new NullProgressMonitor());
        }
        catch (BackingStoreException e) {
            LOGGER.error((Object)"Error occurred while clearing persisted state.", (Throwable)e);
        }
    }

    protected abstract List<WorkingSet> initializeWorkingSets();

    @Override
    public void discardWorkingSetCaches() {
        this.allWorkingSets = null;
        this.visibleWorkingSets = null;
    }

    protected void discardWorkingSetState() {
        this.visibleWorkingSetIds.clear();
        this.orderedWorkingSetIds.clear();
    }

    protected List<WorkingSet> getOrCreateAllWorkingSets() {
        if (this.allWorkingSets != null) {
            return this.allWorkingSets;
        }
        List<WorkingSet> workingSets = this.initializeWorkingSets();
        Collections.sort(workingSets, this);
        this.allWorkingSets = workingSets;
        this.visibleWorkingSets = null;
        return this.allWorkingSets;
    }

    protected List<WorkingSet> getOrCreateVisibleWorkingSets() {
        if (this.visibleWorkingSets != null) {
            return this.visibleWorkingSets;
        }
        List<WorkingSet> workingSets = this.getOrCreateAllWorkingSets();
        this.visibleWorkingSets = this.visibleWorkingSetIds.isEmpty() ? Lists.newArrayList(workingSets) : FluentIterable.from(workingSets).filter(ws -> this.visibleWorkingSetIds.contains(ws.getId())).toList();
        return this.visibleWorkingSets;
    }

    protected void reload() {
        WorkingSetManager activeManager;
        this.discardWorkingSetCaches();
        this.saveState((IProgressMonitor)new NullProgressMonitor());
        if (this.workingSetManagerBroker.isWorkingSetTopLevel() && (activeManager = this.workingSetManagerBroker.getActiveManager()) != null && activeManager.getId().equals(this.getId())) {
            this.workingSetManagerBroker.refreshNavigator();
        }
    }
}

